package evaluator.departureexperiment;


import javax.swing.JButton;

import evaluator.util.ExperimentController;


/**
 * NextButton class
 *
 * <p>Description: Is used to create a next button that invokes the
 * advanceToNext method of the calling evaluatorFrame.</p>
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Hartmut Obendorf, http://asi-www.informatik.uni-hamburg.de/personen/obendorf/
 * @author Harald Weinreich, http://vsis-www.informatik.uni-hamburg.de/~weinreic/
 * @version 1.3
 */

public class MusicalNextButton extends JButton {
  
    public MusicalNextButton(ExperimentController experiment) {
        final ExperimentController _experiment;
        final String CMDLINE = "c:\\Programme\\Winamp\\winamp.exe resources\\evaluator\\jeannie.mp3";

        _experiment = experiment;
        setText("Weiter >");
        setFont(evaluator.util.UIToolbox.PLAINFONT);
        setFocusPainted(false);
        addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
                _experiment.nextTask();
                // Change Visualization...
                try {
                    Process p = Runtime.getRuntime().exec(CMDLINE);

                    p = Runtime.getRuntime().exec(CMDLINE);  // zweimal ist besser...
                } catch (java.io.IOException e) {
                    e.printStackTrace();
                }
            }
        }
        );
    }
}
