package evaluator.departureexperiment;


import scone.netobjects.AccessCache;
import scone.proxy.GeneralResourceGenerator;
import evaluator.util.BlankPageMeg;
import evaluator.util.EvaluatorFrame;
import evaluator.util.LogMessageJavaScriptAdder;


/**
 * The Evaluator scone.Plugin helps to evaluate new link markup options.<BR>
 * <B>ATTENTION!</B><BR>
 * Use with the Lookoflink-Plugin! <BR>
 * See JavasScript-Files in /ressources/lookoflink!
 *
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Hartmut Obendorf, http://asi-www.informatik.uni-hamburg.de/personen/obendorf/
 * @author Harald Weinreich, http://vsis-www.informatik.uni-hamburg.de/~weinreic/
 * @version 1.0
 */
public class Plugin extends scone.Plugin {

    // Clear IE history
    final String COMMAND1 = "resources\\scone\\ClearIEHistory.exe";
    // Clear IE cache
    final String COMMAND2 = "resources\\scone\\ClearIECache.exe";
    // Start Internet Explorer in Background...
    final String COMMAND3 = "resources\\scone\\StartIE.exe http://blank.scone.de/back";

    // requirements
    public int getRequirements() {
        return ACCESSTRACKING | PARSEDOCUMENT;  
        // Accesstracking to find out what the user does
        // ParseDocument to find out about the page titles etc.
    }

    public void init() {
        EvaluatorFrame evaluatorFrame = new EvaluatorFrame(this, "evaluator.departureexperiment.ContentGeneratorForDepartureExperiment5Part2");

        // Notify the experimentController of the actions of the user...
        AccessCache.putObserver(evaluatorFrame.getExperimentController());
      
        // add the blank page Meg
        BlankPageMeg blankPageMeg = new BlankPageMeg();

        blankPageMeg.setup("BlankPageMeg - Returns only blank pages.", BlankPageMeg.BLANKPAGECONDITION, 100);
        addMeg(blankPageMeg);

        // hide the URL in the statusbar
        StatusBarHider sbh = new StatusBarHider();

        sbh.setup("StatusBarHider", HTDOCCONDITION, 60);
        addMeg(sbh);      

        // Show only contents of Heise Pages...
        HeiseNewsContentExtractor hnce = new HeiseNewsContentExtractor();

        // hnce.setup("HeiseNewsContentExtractor","!host=_* & !host=null & host~localhost & content-type=text/html",60);
        hnce.setup("HeiseNewsContentExtractor", "!host=_* & !host=null & (host~www.heise.de | host~local.scone.de) & content-type=text/html", 60);
        addMeg(hnce);      

        // Add Logging-Code to pages...
        LogMessageJavaScriptAdder lmjsa = new LogMessageJavaScriptAdder(this);

        lmjsa.setup("LogMessageJavaScriptAdder", LogMessageJavaScriptAdder.CONDITION, 60);
        addMeg(lmjsa);      

        // local Webserver on local.scone.de -> run/htdocs
        GeneralResourceGenerator.addPath("http://local.scone.de", "resources/experiment-htdocs");

        // Finally try to clear the IE History & Cache and start the whole lot...
        try {
            Process p;

            System.out.print("\nTrying to clear IE history...");
            p = Runtime.getRuntime().exec(COMMAND1);
            System.out.println("OK");
            System.out.print("Trying to clear IE cache...");
            p = Runtime.getRuntime().exec(COMMAND2);
            System.out.println("OK");
            System.out.print("Trying to start IE...");
            p = Runtime.getRuntime().exec(COMMAND3);
            System.out.println("OK");
        } catch (java.io.IOException e) {
            System.out.println("Failed");
            e.printStackTrace();
        }

    }
}

