package evaluator.departureexperiment;


import java.awt.Color;
import java.awt.Component;
import java.util.Date;

import javax.swing.JButton;

import evaluator.util.DataSourceInterface;
import evaluator.util.ExperimentController;
import evaluator.util.UIToolbox;


/**
 * <p>Title: </p>
 * <p>Description: The Startbutton starts an experiment and opens an URL in the Browser. 
 * If you use "blank" instead of an URL a blank page will be displayed.</p>
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Hartmut Obendorf, http://asi-www.informatik.uni-hamburg.de/personen/obendorf/
 * @author Harald Weinreich, http://vsis-www.informatik.uni-hamburg.de/~weinreic/
 * @version 1.3
 */

public class StartButtonWithTimeout extends JButton implements DataSourceInterface {

    private Long        _timestamp;
    private boolean     _written;
    private Component   _toEnable;
    private TimerThread _timerThread = null; 

    public StartButtonWithTimeout(ExperimentController experiment, String url) {
        this(experiment, url, 35000);
    }

    public StartButtonWithTimeout(ExperimentController experiment, String url, long timeout) {
        final ExperimentController _experiment;
        final String _url;
   
        // timeout = 35000; // For debugging purposes...
        _experiment = experiment;
        _url = new String(url);
        _timerThread = new TimerThread(_experiment, timeout);

        _toEnable = null;
        _timestamp = new Long(-1);
        _written = false;

        setEnabled(true);
        setText("Start >");
        setFont(UIToolbox.PLAINFONT);
        setFocusPainted(false);
        addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
                _timestamp = new Long((new Date()).getTime());
                setEnabled(false);
                _timerThread.start();  // Start timeout thread which lets page disappear...
                // _experiment.startTask(System.currentTimeMillis());
                if (_experiment != null) {
                    if (_url.startsWith("blank")) {
                        _experiment.browserControl("BlankPage", "");
                    } else if (_url.equalsIgnoreCase("BringToFront")) {
                        _experiment.browserControl("BringToFront", "");
                    } else if (_url.equalsIgnoreCase("BlurBrowser")) {
                        _experiment.browserControl("BlurBrowser", "");
                    } else {
                        _experiment.browserControl("BringToFront", _url);
                    }
                }            
                if (_toEnable != null) {
                    _toEnable.setEnabled(true);
                }
            }
        }
        );
    }

    public void setComponentToEnable(Component component) {
        _toEnable = component;
        component.setEnabled(false);  // Shall be enabled-> Disable now
    }

    // implementation of DataSourceInterface
    public String getHeader() {
        return "STTS"; // Start TimeStamp
    }

    public String getData() {
        return _timestamp.toString();
    }

    public void next() {
        _written = true;
    }

    public boolean hasMoreData() {
        return !_written;
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (b) {
            this.setBackground(new Color(230, 230, 128));
        } else {
            this.setBackground(new Color(204, 204, 204));
        }
    }

    /**
     * creates a new TimerThread. 
     * 
     * @param ec the experimentcontroller
     * @param sleepTime the time, before the pages disappears...
     */
    class TimerThread extends Thread {
        private ExperimentController _experiment;
        private long _sleepTime;
        public TimerThread(ExperimentController ec, long sleepTime) {
            _experiment = ec;
            _sleepTime = sleepTime;
        }

        /**
         * the run method 
         */
        public void run() {
            if (_sleepTime > 0) {
                try {
                    sleep(_sleepTime);
                    _experiment.browserControl("BlurBrowser", "");
                    _experiment.browserControl("BlankPage", "");
                    // Advance experiment
                    _experiment.nextTask();
                } catch (InterruptedException e) {}
            }
        }
    }
}
