package evaluator.departureexperiment;


import scone.netobjects.LinkToken;
import scone.proxy.HtmlTokenEditor;
import scone.util.ErrorLog;
import scone.util.tokenstream.SconePipe;
import scone.util.tokenstream.Token;
import scone.util.tokenstream.TokenInputStream;
import scone.util.tokenstream.TokenOutputStream;


/**
 * class StatusBarHider
 * <p>Description: Avoids the URL to be displayed in the Statusbar.</p>
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Hartmut Obendorf, http://asi-www.informatik.uni-hamburg.de/personen/obendorf/
 * @author Harald Weinreich, http://vsis-www.informatik.uni-hamburg.de/~weinreic/
 * @version 1.0
 */

public class StatusBarHider extends HtmlTokenEditor {

    public void handleRequest(SconePipe pipe) {
        try {
            TokenInputStream in = pipe.getTokenInputStream();
            TokenOutputStream out = pipe.getTokenOutputStream();
         
            Token t = null;
            LinkToken linkToken = null;
         
            while ((t = in.read()) != null) {
            
                if (t instanceof LinkToken) {
                    linkToken = (LinkToken) t;
               
                    String onMouseOver = "window.statusbar='';";

                    if (linkToken.hasParam("onmouseover")) {
                        onMouseOver += linkToken.getParam("onmouseover");
                        linkToken.removeParam("onmouseover");
                    }
                    onMouseOver += "return true";  // To avoid displaying URL in statusbar.
                    linkToken.setParam("onmouseover", onMouseOver, "onMouseOver");
                }
                out.write(t);
            }
        } catch (Exception exc) {
            ErrorLog.log(this, "handleRequest()", "", exc);
        }
    }
}
