package evaluator.hyperscoutexperiment;


import java.sql.Connection;
import java.sql.Statement;

import scone.netobjects.AccessCache;
import scone.netobjects.DBTableAdapter;
import scone.util.ErrorLog;
import evaluator.util.BlankPageMeg;
import evaluator.util.EvaluatorFrame;
import evaluator.util.LogMessageJavaScriptAdder;


/**
 * The Evaluator Plugin helps evaluate HyperScout.
 *
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Harald Weinreich, http://vsis-www.informatik.uni-hamburg.de/~weinreic/
 * @version 1.0
 */
public class HyperScoutEvaluator extends scone.Plugin {

    // Clear IE history
    final String COMMAND1 = "resources\\scone\\ClearIEHistory.exe";
    // Clear IE cache
    final String COMMAND2 = "resources\\scone\\ClearIECache.exe";
    // Start Internet Explorer in Background...
    final String COMMAND3 = "resources\\scone\\StartIE.exe http://blank.scone.de/back";

    // requirements
    public int getRequirements() {
        return ACCESSTRACKING | PARSEDOCUMENT;
        // Accesstracking to find out what the user does
        // ParseDocument to find out about the page titles etc.
    }

    public void init() {
        System.out.println("");
        // First delete all old access events...
        Statement stmt;
        int results = 0;
        if (DBTableAdapter.useDb()) {  // is the database active?! Then clear former access data!
            try {

                Connection con = DBTableAdapter.getConnection();

                if (con == null) { 
                    System.out.println("   Database not activated!!!");
                } else {
                    stmt = con.createStatement();
                    System.out.println("   Delete access-events from NetNodeTable");
                    results = stmt.executeUpdate("update NetNodeTable set firstAccess=-1, lastAccess=-1, accessCounter=0;");
                    System.out.println("   Delete access-events from ServerTable");
                    results = stmt.executeUpdate("update ServerTable set firstAccess=-1, lastAccess=-1, accessCounter=0;");
                    System.out.println("   Delete access-events from AccessTable");
                    results = stmt.executeUpdate("delete from AccessTable;");
                }
            } catch (Exception e) {
                ErrorLog.log(this, "HyperscoutEvaluator", "Could not delete access events!", e);
            }   
        }

        EvaluatorFrame evaluatorFrame = new EvaluatorFrame(this, "evaluator.hyperscoutexperiment.HyperScoutEvaluatorContentGenerator");

        // Notify the experimentController of the actions of the user...
        AccessCache.putObserver(evaluatorFrame.getExperimentController());
      
        // add the blank page Meg
        BlankPageMeg blankPageMeg = new BlankPageMeg();

        blankPageMeg.setup("BlankPageMeg - Returns only blank pages.", BlankPageMeg.BLANKPAGECONDITION, 100);
        addMeg(blankPageMeg);
      
        // Add Logging-Code to pages...
        LogMessageJavaScriptAdder lmjsa = new LogMessageJavaScriptAdder(this);

        lmjsa.setup("LogMessageJavaScriptAdder", LogMessageJavaScriptAdder.CONDITION, 60);
        addMeg(lmjsa);      

        // Finally try to clear the IE History & Cache and start the whole lot...
        try {
            Process p;

            System.out.print("   Trying to clear IE history...");
            p = Runtime.getRuntime().exec(COMMAND1);
            System.out.println("OK");
            System.out.print("   Trying to clear IE cache...");
            p = Runtime.getRuntime().exec(COMMAND2);
            System.out.println("OK");
            System.out.print("   Trying to start IE...");
            p = Runtime.getRuntime().exec(COMMAND3);
            System.out.println("OK");
        } catch (java.io.IOException e) {
            System.out.println("Failed");
            e.printStackTrace();
        }

    }
}

