package evaluator.util;


import com.ibm.wbi.RequestEvent;
import com.ibm.wbi.RequestRejectedException;
import com.ibm.wbi.protocol.http.DocumentInfo;
import com.ibm.wbi.protocol.http.HttpGenerator;
import com.ibm.wbi.protocol.http.HttpRequest;
import com.ibm.wbi.protocol.http.HttpResponse;
import com.ibm.wbi.protocol.http.beans.StaticHtmlGenerator;


/**
 * BlankPageMeg
 *
 * <p>Description: * This Meg creates blank pages for any URL on the hosts "http://blank.scone.de/"
 * and "http://_blank.scone.de/". Former </p>
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Hartmut Obendorf, http://asi-www.informatik.uni-hamburg.de/personen/obendorf/
 * @author Harald Weinreich, http://vsis-www.informatik.uni-hamburg.de/~weinreic/
 * @version 1.1
 */


public class BlankPageMeg extends HttpGenerator {
    
    public final static String BLANKPAGECONDITION = "host~blank.scone.de | host~_blank.scone.de";
    private final static String BLANKPAGE = "<HTML>\n<HEAD>\n<TITLE>Blank Page</TITLE>\n</HEAD>\n<BODY>\n&nbsp;</BODY>\n</HTML>\n";
    private final static String BLANKBACKGROUNDPAGE = "<HTML>\n<HEAD>\n<TITLE>Blank Page</TITLE>\n</HEAD>\n<BODY onload=\"window.blur();\">\n&nbsp;</BODY>\n</HTML>\n";
    private DocumentInfo documentInfo;
    private String file;
    private HttpRequest request;
    private HttpResponse response;

    public void handleRequest(RequestEvent e) throws RequestRejectedException {
        documentInfo = (DocumentInfo) e.getRequestInfo(); // get RequestInfo
        file = documentInfo.getPath(); // get Path+File of the URL

        StaticHtmlGenerator sg = new StaticHtmlGenerator(); // Return generated document to the client

        if (file.indexOf("back") > 0) {
            sg.setStaticHtml(BLANKBACKGROUNDPAGE);
        } else {
            sg.setStaticHtml(BLANKPAGE);
        }
        response = sg.getHttpResponse(); // Get http response header
        response.setCache(false);
        
        // Send Response to Browser
        try {
            forwardRequest(sg, e);
        } catch (java.io.IOException ex) {
            System.out.println("Error sending response in BlankPageMeg!");
        }
    }
}
