package evaluator.util;


import java.awt.Dimension;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;


/**
 * CertitudeScale
 *
 * <p>Description: How shure are you...?.</p>
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Hartmut Obendorf, http://asi-www.informatik.uni-hamburg.de/personen/obendorf/
 * @author Harald Weinreich, http://vsis-www.informatik.uni-hamburg.de/~weinreic/
 * @version 1.1
 */

public class CertitudeScale extends Box implements DataSourceInterface {
    // class variables
    String          _heading;
    String          _label;
    JRadioButton[]  _buttons;

    boolean         _hasMoreData;
  
    static final int NUM_BUTTONS = 4;

    /**
     * Constructor
     *
     * TODO: Flag setzen, wenn beantwortet? Dann Abfragen durch Next-Button?
     * Highlighten, wenn Next-Button gedrckt?
     * @param ratings number of possible choices (e.g. 5 or 7)
     * @param heading identifier string for selection
     * @param label1  label for minimal rating
     * @param label2  label for maximal rating
     */
    public CertitudeScale(String heading) {
        super(BoxLayout.X_AXIS);

        _heading = heading;
        _label = "Ich bin mir:";
        _buttons = new JRadioButton[NUM_BUTTONS];
        _hasMoreData = true;

        JLabel      jlabel;
        ButtonGroup group = new ButtonGroup();

        jlabel = new JLabel(_label);
        jlabel.setFont(UIToolbox.PLAINFONT);
        jlabel.setForeground(java.awt.Color.black);
        jlabel.setPreferredSize(new Dimension(70, 20));
        add(jlabel);

        add(Box.createRigidArea(new Dimension(10, 0)));

        _buttons[0] = new JRadioButton("sehr sicher");
        _buttons[1] = new JRadioButton("relativ sicher");
        _buttons[2] = new JRadioButton("unsicher");
        _buttons[3] = new JRadioButton("Ich habe geraten");
    
        for (int i = 0; i < _buttons.length; i++) {
            _buttons[i].setFont(UIToolbox.PLAINFONT);
            _buttons[i].setForeground(java.awt.Color.black);
            group.add(_buttons[i]);
            add(_buttons[i]);
            add(Box.createRigidArea(new Dimension(15, 0)));
        }

        add(Box.createHorizontalGlue());
    }

    // implementation of DataSourceInterface
    public String getHeader() {
        return _heading;
    }

    public String getData() {
        String result = "";

        for (int i = 0; i < _buttons.length; i++) {
            if (_buttons[i].isSelected()) {
                result = _buttons[i].getText();
            }
        }

        return result;
    }

    public boolean hasMoreData() {
        return _hasMoreData;
    }

    public void next() {
        _hasMoreData = false;
    }
}
