package evaluator.util;


import javax.swing.JScrollPane;
import javax.swing.JTextArea;


/**
 * Commentpane
 *
 * <p>Description: Allows to enter comments...</p>
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Hartmut Obendorf, http://asi-www.informatik.uni-hamburg.de/personen/obendorf/
 * @author Harald Weinreich, http://vsis-www.informatik.uni-hamburg.de/~weinreic/
 * @version 1.1
 */

public class CommentPane extends JScrollPane implements DataSourceInterface {
    JTextArea   _text;
    String      _heading;
    boolean     _written;

    public CommentPane(String heading, int rows) {            
        _heading = heading;
        _written = false;
        _text = new JTextArea();
        _text.setRows(rows);
        _text.setColumns(32);
        _text.setFont(UIToolbox.PLAINFONT);
        getViewport().setView(_text);
    }

    public String getHeader() {
        return _heading;
    }
  
    public String getData() {
        String result = "\"" + _text.getText() + "\"";

        result = result.replace('\n', ' ');
        return result;
    }

    public boolean hasMoreData() {
        return !_written;
    }
  
    public void next() {
        _written = true;
    }    
}
