package evaluator.util;


import java.awt.Color;
import java.awt.Toolkit;

import javax.swing.ImageIcon;
import javax.swing.JFrame;

import scone.Plugin;
import scone.Scone;


/**
 * EvaluatorFrame class
 *
 * <p>Description: Main Frame for the Evaluator. Also used to quit the avluator and Scone.</p>
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Hartmut Obendorf, http://asi-www.informatik.uni-hamburg.de/personen/obendorf/
 * @author Harald Weinreich, http://vsis-www.informatik.uni-hamburg.de/~weinreic/
 * @version 1.1
 */

public class EvaluatorFrame extends JFrame {
    Plugin                    _plugin;
    ExperimentController      _experiment;
    ContentGeneratorInterface _contentGenerator;

    public static void main(String[] args) {
        new EvaluatorFrame(null, "evaluator.ContentGeneratorForDepartureExperiment");
    }

    public EvaluatorFrame(Plugin plugin, String generatorClassName) {
        _plugin = plugin;

        // Set icon for frame
        ImageIcon img = new ImageIcon("resources/evaluator/logo.gif");

        setIconImage(img.getImage());  // Set icon of program

        _experiment = new ExperimentController(this, _plugin);
        try {
            _contentGenerator = (ContentGeneratorInterface) Class.forName(generatorClassName).newInstance();
        } catch (Exception e) {
            e.printStackTrace();
            close();
        }
        _contentGenerator.init(this, _plugin);
        _contentGenerator.generate(_experiment);

        setTitle("Evaluator");
        setForeground(Color.black);
        setSize(Toolkit.getDefaultToolkit().getScreenSize().width,
                Toolkit.getDefaultToolkit().getScreenSize().height - 28);

        setVisible(true);

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent windowEvent) {
                EvaluatorFrame eframe = (EvaluatorFrame) windowEvent.getWindow();

                eframe.close();
            }
        }
        );

        _experiment.run();
    }

    /**
     * Returns the experimentcontroller of this experiment, e.g. to allow directing events
     * from the browser to the conroller
     */
    public ExperimentController getExperimentController() {
        return _experiment;
    }

    public void close() {
        // Close Browser
        _experiment.browserControl("CloseBrowser", "");
        System.out.println("-> Scone: Closing Browser...\n");
        // Close this window...
        this.setVisible(false);
        // Now terminate Scone/WBI 10000 ms = 10s
        Scone.shutdownWBI(10000);
    }
}
