package evaluator.util;


import java.awt.Dimension;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;


/**
 * <p>Title: </p>
 * <p>Description: Show a Liker-Scale</p>
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Hartmut Obendorf, http://asi-www.informatik.uni-hamburg.de/personen/obendorf/
 * @author Harald Weinreich, http://vsis-www.informatik.uni-hamburg.de/~weinreic/
 * @version 1.0
 */

public class LikertScale extends Box implements DataSourceInterface {
    // class variables
    int             _ratings;
    String          _heading;
    String          _label1;
    String          _label2;
    JRadioButton[]  _buttons;

    boolean         _hasMoreData;

    /**
     * Constructor
     *
     * TODO: Flag setzen, wenn beantwortet? Dann Abfragen durch Next-Button?
     * Highlighten, wenn Next-Button gedrckt?
     * @param ratings number of possible choices (e.g. 5 or 7)
     * @param heading identifier string for selection
     * @param label1  label for minimal rating
     * @param label2  label for maximal rating
     */
    public LikertScale(int ratings, String heading, String label1, String label2) {
        super(BoxLayout.X_AXIS);

        _heading = heading;
        _label1 = label1;
        _label2 = label2;
        _buttons = new JRadioButton[ratings];
        _hasMoreData = true;

        JLabel      jlabel;
        ButtonGroup group = new ButtonGroup();

        jlabel = new JLabel(label1);
        jlabel.setFont(UIToolbox.PLAINFONT);
        jlabel.setForeground(java.awt.Color.black);
        jlabel.setPreferredSize(new Dimension(120, 20));
        add(jlabel);

        add(Box.createRigidArea(new Dimension(10, 0)));
        for (int i = 0; i < _buttons.length; i++) {
            _buttons[i] = new JRadioButton(new Integer(i + 1).toString());
            _buttons[i].setFont(UIToolbox.PLAINFONT);
            group.add(_buttons[i]);
            add(_buttons[i]);
            add(Box.createRigidArea(new Dimension(10, 0)));
        }

        jlabel = new JLabel(label2);
        jlabel.setFont(UIToolbox.PLAINFONT);
        jlabel.setForeground(java.awt.Color.black);
        jlabel.setPreferredSize(new Dimension(120, 20));
        add(jlabel);

        add(Box.createHorizontalGlue());
    }

    // implementation of DataSourceInterface
    public String getHeader() {
        return _heading;
    }

    public String getData() {
        String result = "";

        for (int i = 0; i < _buttons.length; i++) {
            if (_buttons[i].isSelected()) {
                result = _buttons[i].getText();
            }
        }

        return result;
    }

    public boolean hasMoreData() {
        return _hasMoreData;
    }

    public void next() {
        _hasMoreData = false;
    }
}
