package evaluator.util;


import scone.Plugin;
import scone.netobjects.NetNode;
import scone.proxy.HtmlTokenEditor;
import scone.util.tokenstream.HtmlTagToken;
import scone.util.tokenstream.HtmlTextToken;
import scone.util.tokenstream.SconePipe;
import scone.util.tokenstream.Token;
import scone.util.tokenstream.TokenInputStream;
import scone.util.tokenstream.TokenOutputStream;


/**
 * Adds line in header to include the necessary JavaScript code.<P>
 *
 * @author Harald Weinreich
 */
public class LogMessageJavaScriptAdder extends HtmlTokenEditor {

    private Plugin _plugin;
    
    public static final String COPYRIGHT = "(C) Harald Weinreich";
    public static final String CONDITION = "!host=_* & !host=null & content-type=text/html";

    public LogMessageJavaScriptAdder(Plugin plugin) {
        _plugin = plugin;
    }
    
    /**
     * tries to add the preamble:
     * <OL>
     * <LI> before &lt;/head&gt;-Tag
     * <LI> before &lt;body&gt;-Tag
     * <LI> before &lt;frameset&gt;-Tag
     * <LI> before heading
     * <LI> before table
     * <LI> before link (&lt;A&gt; or &lt;AREA&gt;-Tag
     * <LI> before image
     * <LI> before form
     * <LI> before preformatted text
     * </OL>
     */
    public void handleRequest(SconePipe pipe) {
        try {
            TokenInputStream in = pipe.getTokenInputStream();
            TokenOutputStream out = pipe.getTokenOutputStream();

            String nodeId = ((NetNode) in.getMetaInfo().get("baseNode")).getNodeId();
            boolean written = false;
            Token t = null;
            HtmlTagToken tag = null;

            HtmlTextToken preamble = new HtmlTextToken("" + "\n<SCRIPT Language='JavaScript'>\n" + "function _logMessage(message){\n" + "if (document.LogApplet)" + "   document.LogApplet.logMsg('logMessage\\nclassName=evaluator.util.ExperimentController\\nmethod=logMessage\\nparameter='+message+'\\n');\n" + "}\n" + "</SCRIPT>\n");
   		
            while ((t = in.read()) != null) {
   		   
                if (!written && (t instanceof HtmlTagToken)) {
                    tag = (HtmlTagToken) t;

                    if (
                            (tag.getTagType() == tag.T_SCRIPT) ||  // before any other JavaScript Code!
                            (tag.getTagType() == tag.T_BODY) ||    // the body is about to start...
                            (tag.getTagType() == tag.T_H1) ||      // Headings
                            (tag.getTagType() == tag.T_H2)
                            || (tag.getTagType() == tag.T_H3)
                            || (tag.getTagType() == tag.T_H4)
                            || (tag.getTagType() == tag.T_H5)
                            || (tag.getTagType() == tag.T_H6)
                            || (tag.getTagType() == tag.T_TABLE)
                            || (tag.getTagType() == tag.T_A) ||      // Link
                            (tag.getTagType() == tag.T_AREA)
                            || (tag.getTagType() == tag.T_IMG) ||     // Image
                            (tag.getTagType() == tag.T_FORM) ||    // Form
                            (tag.getTagType() == tag.T_PRE))      // Preformatted
                    {
                        out.write(preamble);   // write preamble
                        written = true;
                    }
                }
                out.write(t);
            }
        } catch (Exception exc) {
            exc.printStackTrace();
         
        }
    }     

}
