package evaluator.util;


import java.awt.Color;

import javax.swing.JButton;


/**
 * NextButton class
 *
 * <p>Description: Is used to create a next button that invokes the
 * advanceToNext method of the calling evaluatorFrame.</p>
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Hartmut Obendorf, http://asi-www.informatik.uni-hamburg.de/personen/obendorf/
 * @author Harald Weinreich, http://vsis-www.informatik.uni-hamburg.de/~weinreic/
 * @version 1.3
 */

public class NextButton extends JButton {
    public NextButton(ExperimentController experiment, String label) {
        final ExperimentController _experiment;

        _experiment = experiment;
        setText(label);
        setFont(evaluator.util.UIToolbox.PLAINFONT);
        setFocusPainted(false);
        addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
                _experiment.browserControl("BlankPage", "");
                _experiment.nextTask();
            }
        }
        );
    }

    public NextButton(ExperimentController experiment) {
        this(experiment, "Weiter >");
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (b) {
            this.setBackground(new Color(230, 230, 128));
            this.requestFocus();
        } else {
            this.setBackground(new Color(204, 204, 204));
        }
    }

}
