package evaluator.util;


import java.awt.Color;
import java.awt.Dimension;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;


/**
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Hartmut Obendorf, http://asi-www.informatik.uni-hamburg.de/personen/obendorf/
 * @author Harald Weinreich, http://vsis-www.informatik.uni-hamburg.de/~weinreic/
 * @version 1.3
 */
 
public class OptionsBox extends Box implements DataSourceInterface {
    String          _heading;
    JRadioButton[]  _buttons;
    boolean         _written;
    int             _right = -1; // Which option is correct?

    public OptionsBox(String heading, String label, String[] options) {
        this(heading, label, options, -1);
    }

    public OptionsBox(String heading, String label, String[] options, int right) {
        super(BoxLayout.X_AXIS);

        _right = right; 
        _written = false;

        _heading = heading;
        _buttons = new JRadioButton[options.length];

        ButtonGroup group = new ButtonGroup();
        JLabel      jLabel = new JLabel(label);

        jLabel.setFont(evaluator.util.UIToolbox.PLAINFONT);
        jLabel.setForeground(Color.black);
        jLabel.setPreferredSize(new Dimension(70, 20));
        add(jLabel);
        add(Box.createRigidArea(new Dimension(10, 0)));

        for (int i = 0; i < _buttons.length; i++) {
            _buttons[i] = new JRadioButton(options[i]);
            _buttons[i].setFont(evaluator.util.UIToolbox.PLAINFONT);
            group.add(_buttons[i]);
            add(_buttons[i]);
            add(Box.createRigidArea(new Dimension(10, 0)));
        }

        add(Box.createHorizontalGlue());
    }

    public String getHeader() {
        return _heading;
    }

    public String getData() {
        String result = "";

        for (int i = 0; i < _buttons.length; i++) {
            if (_right == -1) {  // save Text of selected number
                if (_buttons[i].isSelected()) {
                    result = _buttons[i].getText(); // Save Text
                }
            } else {
                if (_buttons[i].isSelected()) {
                    if (i == _right) {
                        result = "right";
                    } else {
                        result = "wrong";
                    }
                }
            
            }
        }
        return result;
    }

    public boolean hasMoreData() {
        return !_written;
    }

    public void next() {
        _written = true;
    }    
}    

