package evaluator.util;


import java.awt.Dimension;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;


/**
 * <p>Title: </p>
 * <p>Description: Show a Scale with discrete percent radio buttons</p>
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Hartmut Obendorf, http://asi-www.informatik.uni-hamburg.de/personen/obendorf/
 * @author Harald Weinreich, http://vsis-www.informatik.uni-hamburg.de/~weinreic/
 * @version 1.3
 */

public class PercentScale extends Box implements DataSourceInterface {
    // class variables
    String          _heading;
    String          _label;
    JRadioButton[]  _buttons;

    boolean         _hasMoreData;

    /**
     * Constructor
     *
     * TODO: Flag setzen, wenn beantwortet? Dann Abfragen durch Next-Button?
     * Highlighten, wenn Next-Button gedrckt?
     * @param ratings number of possible choices (e.g. 5 or 7)
     * @param heading identifier string for selection
     * @param label1  label for minimal rating
     * @param label2  label for maximal rating
     */
    public PercentScale(String heading, String label) {
        super(BoxLayout.X_AXIS);

        _heading = heading;
        _label = label;
        _buttons = new JRadioButton[6];
        _hasMoreData = true;

        JLabel      jlabel;
        ButtonGroup group = new ButtonGroup();

        jlabel = new JLabel(label);
        jlabel.setFont(UIToolbox.PLAINFONT);
        jlabel.setForeground(java.awt.Color.black);
        jlabel.setPreferredSize(new Dimension(70, 20));
        add(jlabel);

        add(Box.createRigidArea(new Dimension(10, 0)));
        for (int i = 0; i < _buttons.length; i++) {
            // _buttons[i] = new JRadioButton((_buttons.length-i-1)*(100 / (_buttons.length-1)) + "%");
            _buttons[i] = new JRadioButton(_buttons.length * (100 / (_buttons.length - 1)) + "%");
            _buttons[i].setFont(UIToolbox.PLAINFONT);
            group.add(_buttons[i]);
            add(_buttons[i]);
            add(Box.createRigidArea(new Dimension(10, 0)));
        }

        add(Box.createHorizontalGlue());
    }

    // implementation of DataSourceInterface
    public String getHeader() {
        return _heading;
    }

    public String getData() {
        String result = "";

        for (int i = 0; i < _buttons.length; i++) {
            if (_buttons[i].isSelected()) {
                result = _buttons[i].getText();
            }
        }

        return result;
    }

    public boolean hasMoreData() {
        return _hasMoreData;
    }

    public void next() {
        _hasMoreData = false;
    }
}
