package evaluator.util;


import javax.swing.JButton;


/**
 * QuitButton class
 *
 * <p>Description: Is used to quit the evaluator.</p>
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Harald Weinreich
 * @version 1.0
 */

public class QuitButton extends JButton {
    public QuitButton(ExperimentController experiment, String label) {
        final ExperimentController _experiment;

        _experiment = experiment;
        setText(label);
        setFont(evaluator.util.UIToolbox.PLAINFONT);
        setFocusPainted(false);
        addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
                _experiment.stopTask();
                _experiment.close();
            }
        }
        );
    }

    public QuitButton(ExperimentController experiment) {
        this(experiment, "Fertig!");
    }
}
