package evaluator.util;


import java.awt.Color;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;


/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Harald Weinreich, http://vsis-www.informatik.uni-hamburg.de/~weinreic/
 * @version 1.0
 */

public class ShortTextEntryBox extends Box implements DataSourceInterface {
    private JTextField _jTextField;
    private String     _heading;
    private boolean    _written;

    /**
     * Constructor with standard Size
     */
    public ShortTextEntryBox(String heading, String label) {
        this(heading, label, 600); // Toolkit.getDefaultToolkit().getScreenSize().width/2);
    }

    /**
     * Set Heading, label and width
     */
    public ShortTextEntryBox(String heading, String label, int width) {
        this(heading, label, width, false); 
    }
  
    /**
     * Set Heading, label, width and enabled
     */
    public ShortTextEntryBox(String heading, String label, int width, boolean enabled) {
        super(BoxLayout.X_AXIS);

        _heading = heading;
        _written = false;

        JLabel jLabel = new JLabel(label + "  ");

        jLabel.setFont(evaluator.util.UIToolbox.PLAINFONT);
        jLabel.setForeground(java.awt.Color.black);
        add(jLabel);

        _jTextField = new JTextField();

        _jTextField.setPreferredSize(new java.awt.Dimension(width, 20));
        _jTextField.setMaximumSize(new java.awt.Dimension(width, 20));
        _jTextField.setEnabled(enabled);

        add(_jTextField);
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        _jTextField.setEnabled(enable);
        if (enable) {
            _jTextField.setBackground(new Color(255, 255, 255));
            _jTextField.requestFocus();
        } else {   
            _jTextField.setBackground(new Color(208, 208, 208));
        }
    }  

    // implementation of data source
    public String getHeader() {
        return _heading;
    }

    public String getData() {
        return "\"" + _jTextField.getText() + "\"";
    }

    public void next() {
        _written = true;
    }

    public boolean hasMoreData() {
        return !_written;
    }
}
