package evaluator.util;


import java.awt.Color;
import java.awt.Component;

import javax.swing.JButton;


/**
 * class StopButton
 *
 * is always disabled at first, must be enabled manually or by setting the
 * toEnable variable of the start button.
 * <p>Description: </p>
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Hartmut Obendorf, http://asi-www.informatik.uni-hamburg.de/personen/obendorf/
 * @author Harald Weinreich, http://vsis-www.informatik.uni-hamburg.de/~weinreic/
 * @version 1.3
 */

public class StopButton extends JButton implements DataSourceInterface {

    private Long      _timestamp;
    private boolean   _written;
    private Component _toEnable;

    public StopButton(ExperimentController experiment) {
        final ExperimentController _experiment;

        _experiment = experiment;
        _written = false;
        _timestamp = new Long(-1);
        _toEnable = null;

        setEnabled(false);
        setText("Stop");
        setFont(UIToolbox.PLAINFONT);
        setFocusPainted(false);
        addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
                _timestamp = new Long(System.currentTimeMillis());
                // _experiment.stopTask(System.currentTimeMillis());
                setEnabled(false);
                if (_toEnable != null) {
                    _toEnable.setEnabled(true);
                }
            }
        }
        );
    }

    public void setComponentToEnable(Component component) {
        _toEnable = component;
        component.setEnabled(false);  // Shall be enabled-> Disable now
    }

    public String getHeader() {
        return "FITS"; // FInish TimeStamp
    }

    public String getData() {
        return _timestamp.toString();
    }

    public void next() {
        _written = true;
    }

    public boolean hasMoreData() {
        return !_written;
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (b) {
            this.setBackground(new Color(230, 230, 128));
            this.requestFocus();
        } else {
            this.setBackground(new Color(204, 204, 204));
        }
    }

}
