package evaluator.util;


import java.awt.Font;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;


/**
 * Class TaskPanel
 *
 * is used to create an empty Screen that can be filled with test items.
 *
 * I don't like to add methods to a "JPanel" that are not consistent with the
 * is-a view on Panels (e.g. addText..)
 * <p>Description: Used to display a Swing-Panel with evaluator-specific components.</p>
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Hartmut Obendorf, http://asi-www.informatik.uni-hamburg.de/personen/obendorf/
 * @author Harald Weinreich, http://vsis-www.informatik.uni-hamburg.de/~weinreic/
 * @version 1.0
 */

public class TaskPanel extends JPanel {
    public TaskPanel() {
        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        setPreferredSize(new java.awt.Dimension(930, 600));
    }

    public void addText(String text) {
        Box           hbox = Box.createHorizontalBox();
        JLabel        label = new JLabel(text);

        label.setFont(UIToolbox.PLAINFONT);
        label.setForeground(java.awt.Color.black);
        hbox.add(label);
        hbox.add(Box.createHorizontalGlue());

        add(hbox);
    }

    public void addText(String text, Font font) {
        Box           hbox = Box.createHorizontalBox();
        JLabel        label = new JLabel(text);

        label.setFont(font);
        label.setForeground(java.awt.Color.black);
        hbox.add(label);
        hbox.add(Box.createHorizontalGlue());

        add(hbox);
    }

    public void addBoldText(String text) {
        Box    hbox = Box.createHorizontalBox();
        JLabel label = new JLabel(text);

        label.setFont(UIToolbox.BOLDFONT);
        label.setForeground(java.awt.Color.black);
        hbox.add(label);
        hbox.add(Box.createHorizontalGlue());

        add(hbox);
    }
  
    public void addSmallText(String text) {
        Box           hbox = Box.createHorizontalBox();
        JLabel        label = new JLabel(text);

        label.setFont(UIToolbox.SMALLFONT);
        label.setForeground(java.awt.Color.black);
        hbox.add(label);
        hbox.add(Box.createHorizontalGlue());

        add(hbox);
    }

    public void addBlueText(String text) {
        Box           hbox = Box.createHorizontalBox();
        JLabel        label = new JLabel(text);

        label.setFont(UIToolbox.PLAINFONT);
        label.setForeground(new java.awt.Color(90, 90, 144));
        hbox.add(label);
        hbox.add(Box.createHorizontalGlue());

        add(hbox);
    }

    public void addItem(java.awt.Component component) {
        Box hbox = Box.createHorizontalBox();

        hbox.add(component);
        hbox.add(Box.createHorizontalGlue());

        add(hbox);
    }

    public void addItems(java.awt.Component component1, java.awt.Component component2) {
        Box hbox = Box.createHorizontalBox();

        hbox.add(component1);
        hbox.add(Box.createRigidArea(new java.awt.Dimension(20, 0)));
        hbox.add(component2);
        hbox.add(Box.createHorizontalGlue());

        add(hbox);
    }
}
