package evaluator.util;


import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;


/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Harald Weinreich, http://vsis-www.informatik.uni-hamburg.de/~weinreic/
 * @version 1.0
 */

public class TextEntryBox extends Box implements DataSourceInterface {
    private JTextField _jTextField;
    private String     _heading;
    private boolean    _written;
    private Component  _toEnable;
  
    /**
     * Constructor with standard Size
     */
    public TextEntryBox(String heading, String label) {
        this(heading, label, 1300); // Toolkit.getDefaultToolkit().getScreenSize().width-200);
    }

    public TextEntryBox(String heading, String label, int width) {
        this(heading, label, width, false); 
    }

    /**
     * Set Heading, label and width.
     */
    public TextEntryBox(String heading, String label, int width, boolean enabled) {
        super(BoxLayout.Y_AXIS);

        _heading = heading;
        _written = false;
        _toEnable = null;

        JLabel jLabel = new JLabel(label + "       ");

        jLabel.setFont(evaluator.util.UIToolbox.PLAINFONT);
        jLabel.setForeground(java.awt.Color.black);
        add(jLabel);

        _jTextField = new JTextField();

        _jTextField.setPreferredSize(new java.awt.Dimension(width, 20));
        _jTextField.setMaximumSize(new java.awt.Dimension(width, 20));
        _jTextField.setEnabled(enabled);
        // javax.swing.text.Document doc = _jTextField.getDocument();
        _jTextField.addActionListener(new TextEntryBoxListener());

        add(_jTextField);
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        _jTextField.setEnabled(enable);
        if (enable) {
            _jTextField.setBackground(new Color(255, 255, 255));
            _jTextField.requestFocus();
        } else {   
            _jTextField.setBackground(new Color(208, 208, 208));
        }
    }  

    /**
     * What component shall be enabled if the user presses RETURN?
     */
    public void setComponentToEnable(Component component) {
        _toEnable = component;
        component.setEnabled(false);  // Shall be enabled-> Disable now
    }

    // implementation of data source
    public String getHeader() {
        return _heading;
    }

    public String getData() {
        return "\"" + _jTextField.getText() + "\"";
    }

    public void next() {
        _written = true;
    }

    public boolean hasMoreData() {
        return !_written;
    }
  
    class TextEntryBoxListener implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (_toEnable != null) {             // Is there a component to be enabled?
                _toEnable.setEnabled(true);
            }     // Yes? Do IT!
            _jTextField.setEnabled(false);         // And disable meself.
        }
    }

}
