package hyperscout;


import scone.netobjects.LinkToken;
import scone.proxy.HtmlTokenEditor;
import scone.util.ErrorLog;
import scone.util.tokenstream.HtmlTagToken;
import scone.util.tokenstream.SconePipe;
import scone.util.tokenstream.Token;
import scone.util.tokenstream.TokenInputStream;
import scone.util.tokenstream.TokenOutputStream;


/**
 * Adds onClick-Events to all A and AREA elements.<p> 
 * These Events make the little popup-Windows visible.<p>
 *
 * @author Harald Weinreich
 * @author Volkert Buchmann 
 */

public class LinkEventAdder extends HtmlTokenEditor {

    public void handleRequest(SconePipe pipe) {
        try {
            TokenInputStream in = pipe.getTokenInputStream();
            TokenOutputStream out = pipe.getTokenOutputStream();
   		
            LinkToken lt = null;
            HtmlTagToken tag = null;
            Token t = null;
            boolean isLink = false;

            while ((t = in.read()) != null) {
                if ((t instanceof LinkToken)) {
                    lt = (LinkToken) t;
                    isLink = true;
               
                    String onMouseOver = "hs_activate(event,'linkid"
                            + lt.getLink().getLinkId() + "');";
                    String onMouseOut = "hs_deactivate();";
                    String onClick = "hs_deactivate();";
      
                    if (lt.hasParam("onmouseover")) {
                        onMouseOver += lt.getParam("onmouseover");
                        lt.removeParam("onmouseover");
                    }
                    if (lt.hasParam("onmouseout")) {
                        onMouseOut += lt.getParam("onmouseout");
                        lt.removeParam("onmouseout");
                    }
                    if (lt.hasParam("onclick")) {
                        onClick += lt.getParam("onclick");
                        lt.removeParam("onclick");
                    }
      
                    lt.setParam("onmouseover", onMouseOver, "onMouseOver");
                    lt.setParam("onmouseout", onMouseOut, "onMouseOut");
                    lt.setParam("onclick", onClick, "onClick");
      
                    // remove title and alt to avoid those popups...
                    if (lt.hasParam("title")) {
                        lt.removeParam("title");
                    }
                    if (lt.hasParam("alt")) {
                        lt.removeParam("alt");
                    }
                }// instanceof LinkToken
                if (t instanceof HtmlTagToken) {
                    tag = (HtmlTagToken) t;
                    if (tag.getTagType() == tag.T_IMG && isLink == true) {
                        tag.removeParam("alt");
                    }
                    if ((tag.getTagType() == tag.T_A
                                    || tag.getTagType() == tag.T_AREA)
                            && tag.isEndTag()) {
                        isLink = false;   
                    }
                }// is HtmlTagToken
                out.write(t);
            }// while
        } catch (Exception exc) {
            ErrorLog.log(this, "handleRequest()", "", exc);
        }      	
    }   
}
