package hyperscout;


import scone.proxy.GeneralResourceGenerator;
import scone.util.ErrorLog;


/**
 * HyperScout: Adds popup-windows to all links
 *
 * @author Harald Weinreich
 * @author Volkert Buchmann 
 */

public class Plugin extends scone.Plugin {

    // requirements
    public int getRequirements() {
        return PARSEDOCUMENT | CONSIDERLINKS | RESOURCEGENERATOR
                | ACCESSTRACKING;  // Usertracking muss nicht sein!
    }

    public void init() {
        try {
            GeneralResourceGenerator.addPath("http://_hyperscout.scone.de/res", "resources/hyperscout");
            // AddPreambleHtmlTokenHandler.addPreambleString("<LINK rel=stylesheet type='text/css' href='http://_hyperscout.scone.de/res/popup.css'>\n");
            // AddPreambleHtmlTokenHandler.addPreambleString("<SCRIPT Language='JavaScript1.2' SRC='http://_hyperscout.scone.de/res/popup.js'></SCRIPT>\n");

            PreamblePopupCodeAdder a = new PreamblePopupCodeAdder();

            a.setup("PreamblePopupCodeAdder", HTDOCCONDITION, 60);
            addMeg(a);
			
            PopupAdder b = new PopupAdder();

            b.setup("PopupAdder", HTDOCCONDITION, 60);
            addMeg(b);
			
            LinkEventAdder c = new LinkEventAdder();

            c.setup("LinkEventAdder", HTDOCCONDITION, 60);
            addMeg(c);
			
            // add the Generator...
            PopupGenerator popupGenerator = new PopupGenerator();

            popupGenerator.setup("popupGenerator", "host~_hyperscout.scone.de", 3);
            addMeg(popupGenerator);		
   		
        } catch (Exception e) {
            ErrorLog.log(this, "init()", "Could not init the HyperScout plugin!", e);
        }
    }
}
