package hyperscout2;


import scone.proxy.HtmlTokenEditor;
import scone.util.ErrorLog;
import scone.util.tokenstream.HtmlTagToken;
import scone.util.tokenstream.HtmlTextToken;
import scone.util.tokenstream.SconePipe;
import scone.util.tokenstream.Token;
import scone.util.tokenstream.TokenInputStream;
import scone.util.tokenstream.TokenOutputStream;


/**
 * Adds onBlur-event to the BODY-Tag to remove popups if page is out of focus.<P>
 *
 * <code>onBlur</code> is called when page taken out of focus.<BR>
 *
 * @author Harald Weinreich
 * @author Volkert Buchmann 
 */
public class BodyEventAdder extends HtmlTokenEditor {

    public static final String COPYRIGHT = "(C) Harald Weinreich & Volkert Buchmann";
    private static final String onBlur = "hs_deactivate();";

    /**
     * tries to add onBlur-Event to the body-tag<P>
     * if no body tag can be found before first:<OL>
     * <LI> heading
     * <LI> table
     * <LI> link (&lt;A&gt; or &lt;AREA&gt;-Tag
     * <LI> image
     * <LI> form
     * <LI> preformatted text
     * <LI> or before EOF
     * </OL>
     * a new body-tag is inserted.
     */
    public void handleRequest(SconePipe pipe) {
        try {
            TokenInputStream in = pipe.getTokenInputStream();
            TokenOutputStream out = pipe.getTokenOutputStream();
   		
            HtmlTagToken tag = null;
            Token t = null;
            boolean written = false;

            while ((t = in.read()) != null) {
                if (!written && (t instanceof HtmlTagToken)) {
                    tag = (HtmlTagToken) t;
   
                    // Add events to &lt;body&gt;-Tag
                    if (tag.getTagType() == tag.T_BODY) {
                        // System.out.println("body tag found.");
                        String onBlur = this.onBlur;
                  
                        // do the attributes exist? read and delete.
                        if (tag.hasParam("onblur")) {
                            onBlur += tag.getParam("onblur");
                            tag.removeParam("onblur");
                        }
         
                        // insert new events
                        tag.setParam("onblur", onBlur, "onBlur");
                        written = true;
                    } else {
                        if (tag.isInBody()) {  
                            // System.out.println("Warning: No body tag! One of the other tags found: inserting body tag.");
                            HtmlTextToken nl = new HtmlTextToken("\n");  // Create New Line Tag
                            HtmlTagToken body = new HtmlTagToken("body");    // Create Body Tag

                            // insert new events
                            body.setParam("onblur", onBlur, "onBlur");
                            out.write(nl);         // new line
                            out.write(body);       // write body-tag
                            out.write(nl);         // new line
                            written = true;
                        }
                    }
                }// if(!written && tag)
                out.write(t);
            }// while
        } catch (Exception exc) {
            ErrorLog.log(this, "handleRequest()", "", exc);
        }           
    }

}
