package hyperscout2;


import java.util.Observable;
import java.util.Observer;

import scone.netobjects.AccessCache;
import scone.netobjects.AccessEvent;
import scone.netobjects.HtmlNode;
import scone.netobjects.HtmlNodeCache;
import scone.netobjects.LinkCache;
import scone.netobjects.LinkVector;
import scone.proxy.GeneralResourceGenerator;


public class Plugin extends scone.Plugin implements Observer {
   
    // requirements
    public int getRequirements() {
        return ACCESSTRACKING | PARSEDOCUMENT | CONSIDERLINKS
                | RESOURCEGENERATOR | RAS; // | SAVESOURCECODE | SAVEBODYTEXT;
        // use ACCESSTRACKING or ACCESSTRACKING2!    | CONSIDERINCLUSIONS 
    }
   
    public int getRasPort() {  
        return 8084;
    }
   
    public void init() {
        GeneralResourceGenerator.addPath("/_hyperscout2/resources", "resources/hyperscout2");

        PopupCodeAdder pAdder = new PopupCodeAdder();

        pAdder.setup("hs2: PopupCodeAdder", HTDOCCONDITION, 60);
        addMeg(pAdder);
      
        LinkEventAdder lea = new LinkEventAdder(this);

        lea.setup("hs2: LinkEventAdder", HTDOCCONDITION, 60);
        addMeg(lea);      

        // Hide Popup if page is left...
        // BodyEventAdder bea=new BodyEventAdder();
        // bea.setup("hs2: BodyEventAdder",HTDOCCONDITION,60);
        // addMeg(bea);      

        LinkDataGenerator.init(this);   // Make hyperscout2-configuration accessible
        
        // AccessCache.putObserver(this);  // Trace Access events

    }

    /**
     * An Access-event occured: Clean Drawingarea and restart Robot.
     *
     */
    public void update(Observable o, Object arg) {
        if (o instanceof AccessCache) {
            AccessEvent e = (AccessEvent) arg;

            System.out.println("HyperScout 2 ---> " + e.getUser().getUserName() + ": " + e.getNode().toString());
            HtmlNode hNode = HtmlNodeCache.check(e.getNode());

            if (hNode == null) {
                System.out.println("hm, das war keine html seite");
            } else {
                System.out.println("Title: " + hNode.getTitle());
                LinkVector lv = LinkCache.getLinksTo(e.getNode());

                System.out.println("Known links to this page: " + lv.size());
                for (int i = 0; i < lv.size(); i++) {
                    System.out.print(HtmlNodeCache.check(lv.linkAt(i).getFromNode()));
                    if (lv.linkAt(i).getFragment().length() > 0) {
                        System.out.println("<-#" + lv.linkAt(i).getFragment());
                    } else {
                        System.out.println();
                    }
                }
                System.out.println("-END---");

            }
        }
    }

}

