package hyperscout2;


import scone.netobjects.NetNode;
import scone.proxy.HtmlTokenEditor;
import scone.util.tokenstream.HtmlTagToken;
import scone.util.tokenstream.HtmlTextToken;
import scone.util.tokenstream.SconePipe;
import scone.util.tokenstream.Token;
import scone.util.tokenstream.TokenInputStream;
import scone.util.tokenstream.TokenOutputStream;


/**
 * Adds line in header to get JavaScript code and Applet.<P>
 *
 * @author Harald Weinreich
 * @author Volkert Buchmann 
 */
public class PopupCodeAdder extends HtmlTokenEditor {

    public static final String COPYRIGHT = "(C) Harald Weinreich & Volkert Buchmann";

    /**
     * tries to add the preamble:
     * <OL>
     * <LI> before &lt;/head&gt;-Tag
     * <LI> before &lt;body&gt;-Tag
     * <LI> before &lt;frameset&gt;-Tag
     * <LI> before heading
     * <LI> before table
     * <LI> before link (&lt;A&gt; or &lt;AREA&gt;-Tag
     * <LI> before image
     * <LI> before form
     * <LI> before preformatted text
     * </OL>
     */
   
    public void handleRequest(SconePipe pipe) {
        try {
            TokenInputStream in = pipe.getTokenInputStream();
            TokenOutputStream out = pipe.getTokenOutputStream();

            String nodeId = ((NetNode) in.getMetaInfo().get("baseNode")).getNodeId();
            boolean written = false;
            Token t = null;
            HtmlTagToken tag = null;

            HtmlTextToken preamble = new HtmlTextToken("" + "\n<SCRIPT Language='JavaScript1.2' SRC='http://localhost:8088/_hyperscout2/resources/popup.js'></SCRIPT>\n" + "<SCRIPT Language='JavaScript1.2'>\n" + "<!--\n" + "if (navigator.appName == \"Netscape\")\n" + " {document.writeln('<div style=\"visibility:visible;\">');}\n" + "else\n" + " {document.writeln('<div style=\"visibility:hidden; position:absolute; top:0px; left:0px;\">');}\n" + "document.writeln('<applet name=\"displayapplet\" code=\"hyperscout2.applet.DisplayApplet\" archive=\"applet.jar\" codebase=\"http://localhost:8088/_hyperscout2/resources/\" width=1 height=1 mayscript></applet>');\n" + "document.writeln('</div>');\n" + "// -->\n" + "</SCRIPT>\n");
   		
            while ((t = in.read()) != null) {
   		   
                if (!written && (t instanceof HtmlTagToken)) {
                    tag = (HtmlTagToken) t;

                    if (
                            // (tag.getTagType()==tag.T_SCRIPT) ||  //before any other JavaScript Code!
                            (tag.getTagType() == tag.T_BODY) ||    // the body is about to start...
                            (tag.getTagType() == tag.T_H1) ||      // Headings
                            (tag.getTagType() == tag.T_H2)
                            || (tag.getTagType() == tag.T_H3)
                            || (tag.getTagType() == tag.T_H4)
                            || (tag.getTagType() == tag.T_H5)
                            || (tag.getTagType() == tag.T_H6)
                            || (tag.getTagType() == tag.T_TABLE)
                            || (tag.getTagType() == tag.T_A) ||      // Link
                            (tag.getTagType() == tag.T_AREA)
                            || (tag.getTagType() == tag.T_IMG) ||     // Image
                            (tag.getTagType() == tag.T_FORM) ||    // Form
                            (tag.getTagType() == tag.T_PRE))      // Preformatted
                    {
                        out.write(preamble);   // write preamble
                        written = true;
                    }
                }
                out.write(t);
            }
        } catch (Exception exc) {
            exc.printStackTrace();
         
        }
    }     

}
