package hyperscout2.applet;


import java.applet.AppletContext;
import java.util.Enumeration;
import java.util.Hashtable;


public class DisplayApplet extends java.applet.Applet {

    PopupWindow popup = null;
    static Hashtable popups = new Hashtable();	// Cache to reduce no of transfers.
    static AppletContext context = null;
    static String browser = System.getProperty("java.vendor");  // Read Browser vendor.
   
    public void start() {
        this.context = getAppletContext();
        popups.clear();   // Remove all Popups from cache to force new data transfer!      
    }
   
    public void stop() {
        hide();
    }
   
    public void init() {
        System.out.println("HyperScout DisplayApplet: init");
    }
   
    /**
     * Show Popup-Window 
     * @param text link id
     * @param x horizontal position
     * @param y vertical position
     */
    public void display(String text, int x, int y, int width, int height) {
        try {
            popup = getPopup(text);
            popup.setMinSize();

            int xPos = 0;
            int yPos = 0;

            if (x > width - popup.getWidth() - 10 - 2) { 
                xPos = x - popup.getWidth() - 6;
            } // Would be out of screen, display left of mousepointer
            else {
                xPos = x + 10;
            } // Right of mouspointer
                     
            if (y > height - popup.getHeight() - 35) { 
                yPos = height - popup.getHeight() - 35;
            }  // Out of screen, leave space for taskbar
            else {
                yPos = y + 12;
            } // A bit under mousepointer
         
            popup.setLocation(xPos, yPos);
            popup.show();
            if (DisplayApplet.browser.indexOf("Netscape") < 0) {
                popup.toFront();
            }  // For IE4 etc.
            popup.repaint();
        } catch (Exception e) {
            e.printStackTrace();
        }
      
    }

    /**
     * Hide popups
     */
    public void hide() {
        if (popup != null) {
            popup.hide();
        }
        // Hide all popups...
        Enumeration en = popups.elements();

        while (en.hasMoreElements()) {
            PopupWindow entry = (PopupWindow) en.nextElement();

            entry.hide();
        }
    }
   
    /**
     * Return a popup from Cache or freshly created...
     */
    PopupWindow getPopup(String linkId) {
        if (popups.get(linkId) != null
                && ((PopupWindow) popups.get(linkId)).doCache())   // In Cache?
        {
            return (PopupWindow) popups.get(linkId);
        }
        PopupWindow popup = new PopupWindow(this, linkId);

        popups.put(linkId, popup);
        return popup;
    }
   
    /**
     * Let browser display other URL
     */
    public static void navigate(String url) {
        try {
            context.showDocument(new java.net.URL(url));      
        } catch (Exception e) {
            e.printStackTrace();
        }
      
    }
   
    /**
     * Infos about this applet!
     */
    public String getAppletInfo() {
        return "This Applet was written by\n" + "Harald Weinreich";
    }

}

