package hyperscout2.applet;


import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.StringTokenizer;


public class PopupLine {

    boolean selected = false;
    boolean mouseOver = false;
   
    Window parent = null;
    Image  image = null;
    String title = null;
    String text = null;
    Rectangle bounds = null;
    FontMetrics fm = null;
    Window popup = null;
    Color color = new Color(Integer.parseInt("FFFFFF", 16));
    int width;

    public PopupLine(Image image, String title, String text, String color, int width, FontMetrics fm) {
        this.image = image;
        this.title = title;
        this.text = text;
        this.color = new Color(Integer.parseInt(color, 16));
        this.width = width;
        this.fm = fm;
        // Calculate height
        String line = "";
        int length = 0;
        int fontHeight = fm.getHeight();
        int height = fontHeight;
        String token = null;
        StringTokenizer st = new StringTokenizer(text);

        while (st.hasMoreTokens()) {
            token = st.nextToken() + " ";
            int w = fm.stringWidth(token);

            length += w;
            if (length > width - 95 && length > w) {
                height += fontHeight;
                line = token;
                length = w;
            } else {
                line += token;
                // length+=w;
            }
         
        }  
        bounds = new Rectangle(0, 0, width, height + 3);
        // bounds     = new Rectangle(0,0,fm.stringWidth(text) + 80, fm.getHeight() + 2);
    }
   
    public void setParent(Window parent) {
        this.parent = parent;
    }
   
    public void setLocation(int x, int y) {
        bounds.setLocation(x, y);
    }
   
    public Rectangle getBounds() {
        return bounds;
    }
   
    public String getTitle() {
        return title;
    }

    public boolean contains(int x, int y) {
        return bounds.contains(x, y);
    }
   
    public void paint(Graphics g) {
        g.setColor(color);
	      
        // Draw icon
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        g.drawImage(image, bounds.x + 2, bounds.y + 2, null);

        // Draw Title text
        g.setColor(Color.black);
        g.setFont(new Font("SansSerif", Font.BOLD, 11));   // ATTENTION: Fontmetrics are set in PopupWindow!
        g.drawString(title, bounds.x + 2 + 15, bounds.y + 13);

        // Draw info text
        g.setFont(new Font("SansSerif", Font.PLAIN, 11));
        // g.drawString(text, bounds.x+2+15+70, bounds.y + 12); //+ bounds.height - 4);

        String line = "";
        int length = 0;
        int height = fm.getHeight();
        int pos = 13;  // height  // War mir eine zu groe Lcke...
        String token = null;
        StringTokenizer st = new StringTokenizer(text);

        while (st.hasMoreTokens()) {
            token = st.nextToken() + " ";
            int w = fm.stringWidth(token);

            length += w;
            if (length > width - 95 && length > w) {
                g.drawString(line, bounds.x + 2 + 15 + 70, bounds.y + pos);
                pos += height;
                line = token;
                length = w;
            } else {
                line += token;
            }
         
        }   
        g.drawString(line, bounds.x + 2 + 15 + 70, bounds.y + pos);

    }
   
}
