package lookoflink;


import scone.proxy.HtmlTokenEditor;
import scone.util.ErrorLog;
import scone.util.tokenstream.HtmlTagToken;
import scone.util.tokenstream.HtmlTextToken;
import scone.util.tokenstream.SconePipe;
import scone.util.tokenstream.Token;
import scone.util.tokenstream.TokenInputStream;
import scone.util.tokenstream.TokenOutputStream;


/**
 * Adds onLoad-event to the BODY-Tag to remove popups if page is out of focus.<P>
 *
 * <code>onLoad</code> is called when page was loaded.<BR>
 *
 * @author Harald Weinreich
 */
public class BodyEventAdder extends HtmlTokenEditor {

    public static final String COPYRIGHT = "(C) Harald Weinreich";
    private static final String onLoad = "changeLinkColor();";

    /**
     * tries to add onLoad-Event to the body-tag<P>
     * if no body tag can be found before first:<OL>
     * <LI> heading
     * <LI> table
     * <LI> link (&lt;A&gt; or &lt;AREA&gt;-Tag
     * <LI> image
     * <LI> form
     * <LI> preformatted text
     * <LI> or before EOF
     * </OL>
     * a new body-tag is inserted.
     */
    public void handleRequest(SconePipe pipe) {
        try {
            TokenInputStream in = pipe.getTokenInputStream();
            TokenOutputStream out = pipe.getTokenOutputStream();
   		
            HtmlTagToken tag = null;
            Token t = null;
            boolean written = false;

            while ((t = in.read()) != null) {
                if (!written && (t instanceof HtmlTagToken)) {
                    tag = (HtmlTagToken) t;
   
                    // Add events to &lt;body&gt;-Tag
                    if (tag.getTagType() == tag.T_BODY) {
                        // System.out.println("body tag found.");
                        String onLoad = this.onLoad;
                  
                        // do the attributes exist? read and delete.
                        if (tag.hasParam("onload")) {
                            onLoad += tag.getParam("onload");
                            tag.removeParam("onload");
                        }
         
                        // insert new events
                        tag.setParam("onload", onLoad, "onLoad");
                        written = true;
                    } else {
                        if (tag.isInBody()) {  
                            // System.out.println("Warning: No body tag! One of the other tags found: inserting body tag.");
                            HtmlTextToken nl = new HtmlTextToken("\n");  // Create New Line Tag
                            HtmlTagToken body = new HtmlTagToken("body");    // Create Body Tag

                            // insert new events
                            body.setParam("onload", onLoad, "onLoad");
                            out.write(nl);         // new line
                            out.write(body);       // write body-tag
                            out.write(nl);         // new line
                            written = true;
                        }
                    }
                }// if(!written && tag)
                out.write(t);
            }// while
        } catch (Exception exc) {
            ErrorLog.log(this, "handleRequest()", "", exc);
        }           
    }

}
