package lookoflink;


import scone.proxy.GeneralResourceGenerator;


/**
 * The Look Of Link Plugin demonstrates new ways to visualize Hyperlinks.
 *
 * @author Harald Weinreich
 * @author Hartmut Obendorf
 */
public class Plugin extends scone.Plugin {

    private static String _visualization;
    // requirements
    public int getRequirements() {
        // return PARSEDOCUMENT | CONSIDERLINKS | CONSIDERINCLUSIONS | RESOURCEGENERATOR;
        return PARSEDOCUMENT | RESOURCEGENERATOR;
    }
    
    public static void setVisualization(String vis) {
        _visualization = vis;
        System.out.println("Changed to " + vis);
    }
    
    public static String getVisualization() {
        return _visualization;
    }

    public void init() {

        GeneralResourceGenerator.addPath("http://_lookoflink.scone.de/resources", "resources/lookoflink");

        _visualization = "normal";
        if (this.getProperties().get("Link marker appearance") != null) {
            _visualization = this.getProperties().get("Link marker appearance");
        }

        ShowLinkCodeAdder pAdder = new ShowLinkCodeAdder(this);

        pAdder.setup("lol: ShowLinkCodeAdder", HTDOCCONDITION, 60);
        addMeg(pAdder);

        // LinkMarkerModifyer lea=new LinkMarkerModifyer(this);
        // lea.setup("lol: LinkMarkerModifyer",HTDOCCONDITION,60);
        // addMeg(lea);

    }
}

