package onefcClient;


import java.util.Hashtable;

import com.ibm.wbi.Editor;
import com.ibm.wbi.RequestEvent;
import com.ibm.wbi.RequestRejectedException;
import com.ibm.wbi.protocol.http.DocumentInfo;

import scone.netobjects.Access;
import scone.netobjects.AccessCache;
import scone.netobjects.AccessEvent;
import scone.netobjects.NetNode;
import scone.netobjects.NetNodeCache;

import com.ibm.wbi.Editor;
import com.ibm.wbi.RequestEvent;
import com.ibm.wbi.RequestRejectedException;
import com.ibm.wbi.protocol.http.DocumentInfo;
import com.ibm.wbi.protocol.http.HttpRequestEditor;
import com.ibm.wbi.protocol.http.HttpRequestHeader;
import com.ibm.wbi.protocol.http.HttpResponseHeader;

/**
 * Adds onLoad-event to the BODY-Tag to remove popups if page is out of focus.<P>
 *
 * <code>onLoad</code> is called when page was loaded.<BR>
 *
 * @author Harald Weinreich
 */
public class OnefcResponseEditor extends Editor  {

    private Plugin _plugin;
    public static final String COPYRIGHT = "(C) Harald Weinreich & Toby Baier";
    private DocumentInfo documentInfo;
    private HttpRequestHeader  request;
    private HttpResponseHeader response;
    private String       sessionServerURI = "";
    
    /**
	 * Constructor with Plugin as parameter
	 */
	public OnefcResponseEditor(Plugin plugin) {
        _plugin = plugin;
    }
	
	
    public void handleRequest(RequestEvent e) throws RequestRejectedException {

        documentInfo = (DocumentInfo) e.getRequestInfo(); // get RequestInfo
        request = documentInfo.getHttpRequestHeader();  // Get the request header

        String host 	= request.getServer();
        Hashtable onefcServers = _plugin.getOnefcServers(); // get Already known servers... Do what you like with them...

        _plugin.getOnefcServers(); // get Already known servers... Do what you like with them...
        
        response = documentInfo.getHttpResponseHeader(); // Get the response header
        sessionServerURI = response.get("onefC-session-ID");

        String accessStatus = response.getCode() == null ? "unknown" : response.getCode();

        // System.out.println("Response status: "+accessStatus);
        // System.out.println("Response onefC : "+sessionServerURI);

        throw new RequestRejectedException();
    }
    
}
