package onefcClient;


import scone.proxy.GeneralResourceGenerator;
import java.util.Hashtable;

/**
 * The Look Of Link Plugin demonstrates new ways to visualize Hyperlinks.
 *
 * @author Harald Weinreich
 * @author Hartmut Obendorf
 */
public class Plugin extends scone.Plugin {

    private static String testAddress;
    private static String onefcTestHeader;
    private static String onefcPort;
    private static Hashtable onefcServers;
    public static final String COPYRIGHT = "(C) Harald Weinreich & Toby Baier";

	// requirements
    public int getRequirements() {
        // return PARSEDOCUMENT | CONSIDERLINKS | CONSIDERINCLUSIONS | RESOURCEGENERATOR;
        return 0;
    }

    public static String getTestAddress() {
        return testAddress;
    }
    
    public static String getOnefcPort() {
        return onefcPort;
    }

    public static Hashtable getOnefcServers() {
        return onefcServers;
    }
    
    public static void setOnefcServers(Hashtable ofcs) {
        onefcServers=ofcs;
    }
    
    public void init() {
        if (this.getProperties().get("Is onefC enabled test address") != null) {
            testAddress = this.getProperties().get("Is onefC enabled test address");
        }
        if (this.getProperties().get("onefC Remote Port") != null) {
            onefcPort = this.getProperties().get("onefC Remote port");
        }

        OnefcRequestEditor oreq = new OnefcRequestEditor(this);
        oreq.setup("onefC: onefcRequestEditor", DECENT_HOST_CONDITION, 60);
        addMeg(oreq);

        OnefcResponseEditor orep = new OnefcResponseEditor(this);
        orep.setup("onefC: onefcResponseEditor", DECENT_HOST_CONDITION, 60);
        addMeg(orep);

    }
}

