/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package scone.accesstracking;




/**
 * This Class allows instances of AppletConnector to access
 * the AccessTracking properties.
 *
 * @author Torsten Hass
 * @version 1.0b, 10/31/2001
 */

public class ConfigAccess {
    private static ConfigAccess _instance = null;
    private scone.Plugin plugin = null;

    private ConfigAccess() {}

    /**
     * Get a sole instance of ConfigAccess, using the Singleton pattern.
     */
    public static ConfigAccess getInstance() {
        if (_instance == null) {
            _instance = new ConfigAccess();
        }
        return _instance;
    }

    public void setPlugin(scone.Plugin plugin) {
        this.plugin = plugin;
    }

    public String getProps(String propertyString) {
        String propString = "";

        try {
            AccessTracking.props.get(propertyString);
        } catch (Exception e1) {
            System.out.println("AccessTracking:ConfigAccess: \"" + propertyString + "\" not found in Properties.");
        }
        return propString;
    }

}   

