/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package scone.accesstracking;


import scone.proxy.HtmlTokenEditor;
import scone.util.ErrorLog;
import scone.util.tokenstream.HtmlTagToken;
import scone.util.tokenstream.SconePipe;
import scone.util.tokenstream.Token;
import scone.util.tokenstream.TokenInputStream;
import scone.util.tokenstream.TokenOutputStream;


/**
 * Adds events to the BODY-Tag to track the actions of a user.<P>
 *
 * <code>onLoad</code> is called after the page was loaded<BR>
 * <code>onUnload</code> is called when a page is left<P>
 *
 * @author Harald Weinreich
 * @author Volkert Buchmann 
 * modified by Torsten Hass
 */
public class FormSubmitEventAdder extends HtmlTokenEditor {

    public static final String COPYRIGHT = "(C) Harald Weinreich & Volkert Buchmann";
    private static final String onSubmit = ");";

    /**
     * tries to add an onsubmit-event to the form-tag<P>
     */
    public void handleRequest(SconePipe pipe) {
        try {
            TokenInputStream in = pipe.getTokenInputStream();
            TokenOutputStream out = pipe.getTokenOutputStream();
   		
            HtmlTagToken tag = null;
            Token t = null;
            boolean written = false;

            while ((t = in.read()) != null) {
                if ( /*!written && */(t instanceof HtmlTagToken)) {
                    tag = (HtmlTagToken) t;
   
                    // Add event to <form>-Tag
                    if ((tag.getTagType() == tag.T_FORM) && (!tag.isEndTag())) {
                        String onSubmit = "_scone_form('";

                        onSubmit += tag.getParam("action") + "');";
                  
                        // do the attributes exist? read and delete.
                        if (tag.hasParam("onsubmit")) {
                            onSubmit += tag.getParam("onsubmit"); 
                            tag.removeParam("onsubmit"); 
                        }
         
                        // insert new events
                        tag.setParam("onsubmit", onSubmit, "onSubmit");
                        written = true;
                    }
                }
                out.write(t);
            }// while
        } catch (Exception exc) {
            ErrorLog.log(this, "handleRequest()", "", exc);
        }           
    }

}
