package scone.accesstracking;




/**
 * Diese Klasse enthlt Daten ber die momentan angezeigte Internet
 * Seite einer bestimmten IE Instanz
 */
public class IESpyData {

    // BitArray AppletStarted
    private final int AS_STARTTIME = 1 << 0;     // startTime was set
    private final int AS_USERID = 1 << 1;     // userId was set
    private final int AS_NODEID = 1 << 2;     // nodeId was set
    private final int AS_FRAGMENT = 1 << 3;     // fragment was set
    private final int AS_QUERY = 1 << 4;     // query was set
    private final int AS_FRAMENAME = 1 << 5;     // frameName was set
    private final int AS_PARENTNODE = 1 << 6;     // parentNodeName was set
    private final int AS_PARENTFRAME = 1 << 7;     // parentFrameName was set
    private final int AS_REFERRER = 1 << 8;     // referrer was set
    private final int AS_FRAMECOUNT = 1 << 9;     // frameCount was set
    private final int AS_COMPLETE = 0x3FF;    // all bits set
    private int asBitArray = 0;
   
    private long startTime;
    private String userId;
    private String nodeId;
    private String fragment;
    private String query;
    private String frameName;
    private String parentNodeName;
    private String parentFrameName;
    private String referrer;
    private int frameCount;
   
    public void setStartTime(long startTime) {
        this.startTime = startTime;
        asBitArray = asBitArray | AS_STARTTIME;
    }
   
    public void setUserId(String userId) {
        this.userId = userId;
        asBitArray = asBitArray | AS_USERID;
    }
   
    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
        asBitArray = asBitArray | AS_NODEID;
    }
   
    public void setFragment(String fragment) {
        this.fragment = fragment;
        asBitArray = asBitArray | AS_FRAGMENT;
    }
   
    public void setQuery(String query) {
        this.query = query;
        asBitArray = asBitArray | AS_QUERY;
    }
   
    public void setFrameName(String frameName) {
        this.frameName = frameName;
        asBitArray = asBitArray | AS_FRAMENAME;
    }
   
    public void setParentNodeName(String parentNodeName) {
        this.parentNodeName = parentNodeName;
        asBitArray = asBitArray | AS_PARENTNODE;
    }
   
    public void setParentFrameName(String parentFrameName) {
        this.parentFrameName = parentFrameName;
        asBitArray = asBitArray | AS_PARENTFRAME;
    }
   
    public void setReferrer(String referrer) {
        this.referrer = referrer;
        asBitArray = asBitArray | AS_REFERRER;
    }
   
    public void setFrameCount(int frameCount) {
        this.frameCount = frameCount;
        asBitArray = asBitArray | AS_FRAMECOUNT;
    }
   
    public void clearAppletStarted() {
        asBitArray = 0;  
    }
   
    public boolean startedComplete() {
        return (asBitArray == AS_COMPLETE);  
    }
   
    public long getStartTime() {
        return startTime;
    }
   
    public String getUserId() {
        return userId;
    }
   
    public String getNodeId() {
        return nodeId;
    }
   
    public String getFragment() {
        return fragment;
    }
   
    public String getQuery() {
        return query;
    }
   
    public String getFrameName() {
        return frameName;
    }
   
    public String getParentNodeName() {
        return parentNodeName;
    }
   
    public String getParentFrameName() {
        return parentFrameName;
    }
   
    public String getReferrer() {
        return referrer;
    }
   
    public int getFrameCount() {
        return frameCount;
    }
   
}  
