/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package scone.accesstracking;


// import java.io.*;
import java.util.Set;


// import scone.netobjects.Access;

/**
 * This Class can be inherited by classes that want to be informed
 * on any change of open frames.
 *
 * @author Torsten Hass
 * @version 1.0b, 11/05/2002
 */

public class MyFrameAccess extends FrameAccessObject {

    private Object FATester = null;  // handle to FrameAccessTest
   
    public MyFrameAccess(Object FATester) {
        this.FATester = FATester;
    }   
   
    public void framesChanged(Set contents) {
      
        ((FrameAccessTest) FATester).framesChanged(contents); // call the method framesChanged in FrameAccessTest
      
    }

}   

