/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package scone.accesstracking2;

import scone.util.ErrorLog;
import scone.util.PersistentProperties;


public class AccessTracking extends scone.Plugin {

    public static PersistentProperties props = new PersistentProperties("config/scone/accesstracking.xml");

    // requirements!
    public int getRequirements() {
        return CONSIDERLINKS | PAGETIMEOUT ; // | NOCACHE;
    }

    /**
     * Initialize new Accesstracking without applet
     */
    public void init() {
        // System.out.print("\n          ");
        try {

            // This adds a little JavaScript block to the beginning of HTML-File, that
            // stores the actual time for calculating load time and staytime
            TimeStoreScriptAdder tssAdder = new TimeStoreScriptAdder();
            tssAdder.setup("AccessTracking2: TimeStoreScriptAdder", HTDOCCONDITION, 80);  // After the ParsingMeg (90)!
            addMeg(tssAdder);

            // This adds the call for the external JavaScript file to HTML file
            JavaScriptAdder jAdder = new JavaScriptAdder();

            jAdder.setup("AccessTracking2: JavaScriptAdder", HTDOCCONDITION, 60);
            addMeg(jAdder);

            // This adds onLoad and onUnload-Events to the BODY-Tag.
            // onload is necessary, as oterwise sometimes no access-eventa are created.
            // -> The picture _scone_axxxxx bzw. /_start is not loaded!?!
            // unLoad sends a event if a user leaves a page.
            BodyEventAdder beAdder = new BodyEventAdder();

            beAdder.setup("AccessTracking2: BodyEventAdder", HTDOCCONDITION, 60);
            addMeg(beAdder);

            // The LinkEvents create events if a user click on a link.
            // This slows down parsing of thepage, as "CONSIDERLINKS" has to be used.
            LinkEventAdder leAdder = new LinkEventAdder();

            leAdder.setup("AccessTracking2: LinkEventAdder", HTDOCCONDITION, 60);
            addMeg(leAdder);

            // The onsubmit events of forms creates an event if a user submits a form.
            FormSubmitEventAdder fsAdder = new FormSubmitEventAdder();

            fsAdder.setup("AccessTracking: FormSubmitEventAdder", HTDOCCONDITION, 60);
            addMeg(fsAdder);

    	    // Main Meg to trace the user actions...
            AccessTrackingMeg accessTrackingMeg = new AccessTrackingMeg();

            accessTrackingMeg.setup("AccessTracking2: AccessTrackingMeg", "host~tracking.scone.de", 100);
            addMeg(accessTrackingMeg);

            // Use this meg to log also access to Non-html-pages.
            if (props.get("Create events for non-HTML documents") != null
                    && props.get("Create events for non-HTML documents").equals("true")) {
                NoHTMLAccessMeg noHTML = new NoHTMLAccessMeg(this);
                noHTML.setup("AccessTracking2: NoHTMLAccessMeg", NO_HTDOCCONDITION, 60);
                addMeg(noHTML);
            }

        } catch (Exception e) {
            ErrorLog.log(this, "init()", "Could not enable AccessTracking!", e);
        }

    }

}
