/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2004 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package scone.accesstracking2;


import scone.netobjects.Access;
import scone.netobjects.AccessCache;
import scone.netobjects.AccessEvent;


/**
 * The methods of this class are called by AccessTrackingMeg. Every
 * message of the meg has its own method to evaluate the received
 * information and to create and change Access events.
 * <P>
 * This EventDecoder gets its events from a special modified version of FireFox. 
 *
 * @author Harald Weinreich, Hartmut Obendorf
 * @version 1.5, 20-Aug-2004
 */


public class EventDecoderFirefox extends EventDecoder {
    // constants for bit array action, indicating the action
    // the user performed to get to this page

    protected final int MAXHISTORY = 50;  // Mozilla maximum history length

    protected BrowserHistory bh;
    protected int browserName;
    protected boolean accessEventExisted;
    protected boolean showMessages;

    public EventDecoderFirefox() {
        bh = BrowserHistory.getInstance();
        accessEventExisted = false;
        browserName = FIREFOX;
    }

    /**
     * This method is called from AccesstrackingMeg. It decodes the events
     * it gets from firefox and creates and broadcasts accessEvents.
     *
     * @param userId
     * @param nodeId
     * @param start
     * @param frame
     * @param event the Event...
     * @param uriString URL of the current window
     * @param history Number of Frames in page
     */
    void event( 
                    String userId,
                    String nodeId,
                    long start,
                    String frame,
					String event,
                    String uriString,
                    int history ) {

        if (frame.equals("") || nodeId.equals("") ) {
            // System.out.println("START: Window name missing - probably an iframe!");
            return; // No frame name, no nodeID - not really an event...
        }
        
        // System.out.println("--- Methode Started");
        // Create a new Access event, test if the page comes from browser's
        // cache, store all data of the applet in the access event.
        Access a = AccessCache.get(userId, nodeId, start, frame);

        a.setAction(BROWSER_FIREFOX| a.getAction() );
        a.setEvent(event);
        
        // a.setAction(action);
        // a.store(); -> Save if user leaves a page...
        AccessCache.broadcastEvent(new AccessEvent(a));   // Now broadcast event again with Action infos...!
    }

}
