/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package scone.accesstracking2;


public class UriStripper {
    private static String fullAddress;
    private static String uri;
    private static String fragment;
    private static String search;
   
    public UriStripper(String fullAddress) {
        this.fullAddress = fullAddress;
        if (fullAddress.indexOf("?") > -1) {
            search = fullAddress.substring(fullAddress.indexOf("?"), fullAddress.length() - 1);
            uri = fullAddress.substring(0, fullAddress.indexOf("?"));
        } else {
            uri = fullAddress;
            search = "";
        }
        if (uri.indexOf("#") > -1) {
            fragment = uri.substring(uri.indexOf("#"), uri.length() - 1);
            uri = uri.substring(0, uri.indexOf("#"));
        } else {
            fragment = "";
        }
    }   

    public String getFragment() {
        return fragment;
    }
   
    public String getSearch() {
        return search;
    }
   
    public String getUri() {
        return uri;
    }   
}   

