package scone.examples.magnifier;


import scone.proxy.HtmlTokenEditor;
import scone.util.ErrorLog;
import scone.util.tokenstream.HtmlTagToken;
import scone.util.tokenstream.SconePipe;
import scone.util.tokenstream.Token;
import scone.util.tokenstream.TokenInputStream;
import scone.util.tokenstream.TokenOutputStream;


public class Magnifier extends HtmlTokenEditor {

    public static final String COPYRIGHT = "(C) Harald Weinreich & Arne Zhlsdorf";
    private static final String styleH1 = "font-size: 380%;";
    private static final String styleH2 = "font-size: xx-large;";
    private static final String styleH3 = "font-size: x-large;";

    MagnifierPlugin plugin = null;

    public Magnifier(MagnifierPlugin plugin) {
        this.plugin = plugin;
    }

    public void handleRequest(SconePipe pipe) {
        try {

            TokenInputStream in = pipe.getTokenInputStream();
            TokenOutputStream out = pipe.getTokenOutputStream();

            Token t = null;
            HtmlTagToken tag = null;
            boolean h1Magnified = false;
            boolean h2Magnified = false;
            boolean h3Magnified = false;
            int fontMagnified = 3;  // Nur 3 mal!

            while ((t = in.read()) != null) {

                if (t instanceof HtmlTagToken) {
                    tag = (HtmlTagToken) t;

                    if (!h1Magnified && tag.getTagType() == tag.T_H1) {
                        System.out.println("H1-Tag found.");
                        String style = this.styleH1;

                        // do the attributes exist? read and delete.
                        if (tag.hasParam("style")) {
                            style += tag.getParam("style");
                            tag.removeParam("style");
                        }

                        // insert new events
                        tag.setParam("style", style, "style");
                        h1Magnified = true;
                    }
                    if (!h2Magnified && tag.getTagType() == tag.T_H2) {
                        System.out.println("H2-Tag found.");
                        String style = this.styleH2;

                        // do the attributes exist? read and delete.
                        if (tag.hasParam("style")) {
                            style += tag.getParam("style");
                            tag.removeParam("style");
                        }

                        // insert new events
                        tag.setParam("style", style, "style");
                        h2Magnified = true;
                    }
                    if (fontMagnified > 0 && tag.getTagType() == tag.T_FONT) {
                        String size = "";

                        // do the attributes exist? read and delete.
                        if (tag.hasParam("size")) {
                            size = tag.getParam("size");
                            tag.removeParam("size");
                            System.out.println("font-Tag found. size:" + size);

                            if (size.equals("+4")) {
                                size = "+6";
                                fontMagnified--;
                            }
                            if (size.equals("+3")) {
                                size = "+5";
                                fontMagnified--;
                            }
                            if (size.equals("+2")) {
                                size = "+4";
                                fontMagnified--;
                            }
                            if (size.equals("+1")) {
                                size = "+3";
                                fontMagnified--;
                            }
                            if (size.equals("6")) {
                                size = "8";
                                fontMagnified--;
                            }
                            if (size.equals("5")) {
                                size = "7";
                                fontMagnified--;
                            }
                            if (size.equals("4")) {
                                size = "6";
                                fontMagnified--;
                            }

                            tag.setParam("size", size, "size");

                        }
                    }
                }// if(!written && tag)
                out.write(t);
            }
        } catch (Exception exc) {
            ErrorLog.log(this, "handleRequest()", "", exc);
        }
    }
}
