package scone.examples.rueckspiegel;


import java.awt.Image;
import java.awt.geom.Rectangle2D;

import scone.netobjects.HtmlNode;


/**
 * This class represents a node displayed in the visualization
 *
 *
 * @author Frank Wollenweber
 */



class TreeNode {
    
    private HtmlNode hnode; // Display this htmlNode
    private Rectangle2D.Double rect; // The rectangle around the thumbnail
    private Image thumbnail; // The thumbnail of this html document

    /**
     * Default Constructor.
     */
    TreeNode() {}

    /**
     * Get the rectangle around the thumbnail
     * @return rectangle
     */
    Rectangle2D.Double getRect() {
        return rect;
    }

    /**
     * Set the rectangle around the thumbnail
     * @param r rectangle
     */
    void setRect(Rectangle2D.Double r) {
        rect = r;
    }

    /**
     * Get the thumbnail image
     * @return thumbnail
     */
    Image getThumbnail() {
        return thumbnail;
    }

    /**
     * Set the thumbnail image
     * @param t thumbnail
     */
    void setThumbnail(Image t) {
        this.thumbnail = t;
    }

    /**
     * Get the htmlNode visulized by this TreeNode
     * @return htmlNode
     */
    HtmlNode getHtmlNode() {
        return hnode;
    }

    /**
     * Set the htmlNode visualized by this TreeNode
     * @param hn htmlNode
     */
    void setHtmlNode(HtmlNode hn) {
        hnode = hn;
    }
}
