package scone.examples.statusbar;


import scone.netobjects.DBTableAdapter;
import scone.netobjects.HtmlNode;
import scone.netobjects.HtmlNodeCache;
import scone.netobjects.LinkToken;
import scone.proxy.HtmlTokenEditor;
import scone.util.ErrorLog;
import scone.util.tokenstream.SconePipe;
import scone.util.tokenstream.Token;
import scone.util.tokenstream.TokenInputStream;
import scone.util.tokenstream.TokenOutputStream;


public class StatusBarWizard extends HtmlTokenEditor {

    StatusBarWizardPlugin plugin = null;

    public StatusBarWizard(StatusBarWizardPlugin plugin) {
        this.plugin = plugin;
    }

    public void handleRequest(SconePipe pipe) {
        try {
            if (plugin.getProperties().get("no-cache").equals("true")) {
                setResponseHeaderField("Pragma", "no-cache");
            }         
            
            TokenInputStream in = pipe.getTokenInputStream();
            TokenOutputStream out = pipe.getTokenOutputStream();
         
            Token t = null;
            LinkToken linkToken = null;
         
            while ((t = in.read()) != null) {
            
                if (t instanceof LinkToken) {
                    linkToken = (LinkToken) t;
                    HtmlNode doc = HtmlNodeCache.check(linkToken.getLink().getToNode());
               
                    if (doc != null) {
                        String jsEvent = "status='"
                                + DBTableAdapter.escape(doc.getTitle())
                                + "';return true";

                        linkToken.setParam("onMouseOver", jsEvent);
                        linkToken.setParam("onMouseOut", "status='';return true;");
                    }
                }
                out.write(t);
            }
        } catch (Exception exc) {
            ErrorLog.log(this, "handleRequest()", "", exc);
        }
    }
}
