/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.netobjects;


/**
 * used to tell all interested observers about the latest webpage
 * loaded into the browser<p>
 *
 * @author   Matthias Mayer
 * @author   Volkert Buchmann
 */
public class AccessEvent {
 
    // fields
    protected Access access;

    /**
     * creates a new AccessEvent
     * @param access the Access object describing the access
     */
    public AccessEvent(Access access) {
        this.access = access;
    }

    /**
     * returns the accessed NetNode
     * @return the NetNode
     */
    public NetNode getNode() {
        return access.getNode();	
    }

    /**
     * returns the Frame in which the NetNode is displayed
     * @return the frame
     */
    public Frame getFrame() {
        return new Frame(access.getFrameName());
    }

    /**
     * returns the user who accessed the node
     * @return the user
     */
    public User getUser() {
        return access.getUser();	
    }

    /**
     * returns the Access object
     * @return the Access object
     */
    public Access getAccess() {
        return access;
    }

}

