/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.netobjects;


/**
 * defines an object that can be stored in a CacheTable
 */

public interface Cacheable {

    /**
     * returns the hashkey for this object (to be deprecated!)
     * @param keyNo the number of the key to be generated
     * @return the key
     */
    public Object getKey(int keyNo);
	
    /**
     * writes a persistent representation of the object to the storage.
     * For example the scone database.
     */
    public void store();
	
    /**
     * sets the CacheTableEntryInterface
     * @param ctei the CacheTableEntryInterface
     */
    public void setCacheTableEntryInterface(CacheTableEntryInterface ctei);
}
