/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.netobjects;


/**
 * holds the values of a TableRecord object.<br>
 * This is a Hashtable which notifies a TableRecord object when it has been changed.<p>
 */
public class FieldValueHashTable extends java.util.Hashtable {
	
    // the TableRecord objects which holds this data
    private TableRecord set = null;

    /**
     * creates a new FieldValueHashTable object
     * @param set the TableRecord which will be notified if any changes occur
     */
    public FieldValueHashTable(TableRecord set) {
        this.set = set;
    }
	
    /**
     * sets a field to the specified value and notifies the DBset object
     * value must be a String!
     * @param name the name of the field
     * @param value the value
     */
    public void put(String name, Object value) {
        this.put(name, (String) value);
    }
	
    /**
     * sets a field to the specified value and notifies the DBset object
     * @param name the name of the field
     * @param value the value
     */
    public void put(String name, String value) {
        try {
            super.put(name, value);
            set.setChanged(true);
        } catch (Exception e) {
            System.out.println("FieldValueHashTable: trying to set a fieldValue in a nonexisting TableRecord!");
            e.printStackTrace();
        }
		
    }
	
    /**
     * returns the value of the specified field
     * @param name the name of the field
     */
    public String get(String name) {
        return (String) super.get(name);
    }
	
}
