/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.netobjects;


import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Vector;


/**
 * caches all Inclusion objects.
 * <br>
 * use the static methods provided by this class to obtain Inclusion objects.
 *
 * @author Harald Weinreich
 * @author Volkert Buchmann
 */

public class InclusionCache implements TableRecordCacheInterface {

    protected static CacheTable cache;

    protected static Object lock = new Object();
   
    public static void init(int timeTillCleanUp, int gcType) {
        cache = new CacheTable("Inclusions", 2, timeTillCleanUp, gcType);
        lock = new Object();
    }

    /**
     * get/create an Inclusion which is defined in parent and includes child
     * @param parent the parent node
     * @param child the child node
     * @return the inclusion
     */
    public static Inclusion get(NetNode parent, NetNode child) {
        Inclusion inclusion = null;
        String key = createKey(parent.getNodeId(), child.getNodeId());

        synchronized (lock) {
            inclusion = (Inclusion) cache.get(1, key);
            if (inclusion == null) {
                inclusion = new Inclusion(parent, child);
                cache.put(inclusion);
            }
        }
        return inclusion;
    }

    /**
     * returns the inclusion specified by the id
     * @param id the id
     * @return the inclusion
     */
    public static Inclusion getById(String id) {
        Inclusion inclusion = null;

        synchronized (lock) {
            inclusion = (Inclusion) cache.get(0, id);
            if (inclusion == null) {
                inclusion = new Inclusion(id);   // Read from DB, as not in cache.
                cache.put(inclusion);
            }
        }
        return inclusion;
    }

    /**
     * Returns all inclusion objekts of a NetNode
     * @param from the NetNode
     * @return the links
     */
    public static Vector getIncludedObjects(NetNode from) {
        return getInclusions("where parentNodeId='" + from.getNodeId() + "'");
    }

    /**
     * This method returns a Vector of Inclusions to a given query string
     * @param sqlClause The where clause for the query string.
     */
    public static Vector getInclusions(String sqlClause) {
        clean();  // fist store data to DB!
        Connection con = Inclusion.dbTable.getConnection();
        Vector inclusions = new Vector();
        int i = 0;

        synchronized (lock) {
            ResultSet results = Inclusion.dbTable.queryDb(con, Inclusion.dbTable.getTableName(), sqlClause);

            // eval all records returned...
            while (results != null) {
                Inclusion inclusion = new Inclusion(results);  // Create new use object
                String id = inclusion.getInclusionId();

                if (id.length() > 0 && !id.equals("-1")) // another set read from DB      
                {              
                    // System.out.println(results.getString("userId") + "  " +results.getString("userName"));
                    if (cache.get(0, id) == null) {   // not known in cache...
                        cache.put(inclusion);
                    }
                    inclusions.add(inclusion);
                } else {  // End of results reached!
                    return inclusions;
                }
            }
        }
        return inclusions;
    }

    /**
     * returns the hashkey for the two strings
     */
    protected static String createKey(String a, String b) {
        return a + "/" + b;
    }

    public static void clean() {
        cache.clean();
    }  
}
