/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.netobjects;




/**
 * represents a keyword of a NetNode object.<br>
 *
 * It may for example be a word defined in the HTML meta-keyword tag.
 *
 * @author Harald Weinreich
 * @author Volkert Buchmann
 */

public class Keyword extends TableRecord {
    public static final String COPYRIGHT = "(C) Harald Weinreich & Volkert Buchmann";

    protected static DBTableAdapter dbTable;

    // set sql meta-data
    static {
        dbTable = new DBTableAdapter("KeywordTable"); 

        /*
         dbTable.addField("keywordId",dbTable.STRING, "", dbTable.KEY);
         dbTable.addField("keyword",  dbTable.STRING, "", dbTable.FIELD);
         */
    }

    /**
     * returns the id of this keyword
     * @return the id
     */
    public String getKeywordId() {
        return fieldValues.get("keywordId");
    }

    /**
     * returns the keyword in String representation
     * @return the keyword
     */
    public String getKeyword() {
        return fieldValues.get("keyword");
    }
	
    // returns the keyword with the specified id
    public Keyword(int keywordId) {
        dbTable.init(this);
        fieldValues.put("keywordId", String.valueOf(keywordId));
        dbTable.dbInit(this);
    }

    // creates a new keyword
    public Keyword(String keyword) {
        dbTable.init(this);
        fieldValues.put("keywordId", SimpleUri.getHexHashCode(keyword.toLowerCase()));
        dbTable.dbInit(this);
        fieldValues.put("keyword", keyword.toLowerCase());
    }
	
    public void store() {
        dbTable.updateDB(this);
    }	
	
    public Object getKey(int KeyNo) {
        switch (KeyNo) {
        case 0:
            return getKeywordId();

        case 1:
            return getKeyword();

        default:
            return "";
        }
    }
}
