/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.netobjects;


import scone.util.tokenstream.HtmlTagToken;
import scone.util.tokenstream.Token;


/**
 * a <code>HtmlToken</code> for a link
 *
 * @author Harald Weinreich
 * @author Volkert Buchmann 
 */

public class LinkToken extends HtmlTagToken implements Token {
    public static final String COPYRIGHT = "(C) Harald Weinreich & Volkert Buchmann";
 	
    /**
     * the <code>Link</code>
     */
    protected Link link;
	
    /**
     * changes a <code>HtmlToken</code> into a <code>LinkToken</code>
     *
     * @param t the <code>HtmlToken</code>
     */
	
    public LinkToken(HtmlTagToken t, Link link) {
        super(t, new StringBuffer("")); // t.getWhiteSpaces()));
        this.link = link;
    }
	
    public Token getClone() {
        return new LinkToken(this, link);
    }
	
    /**
     * returns the <code>Link</code> of the <code>LinkToken</code>
     */
    public Link getLink() { 
        return link; 
    }
}
