/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.netobjects;


/**
 * a <code>Vector</code> of Link objects
 *
 * @author Harald Weinreich
 * @author Volkert Buchmann
 */
public class LinkVector extends java.util.Vector {

    /**
     * creates an empty <code>LinkVector</code>
     */
    public LinkVector() {
        super();
    }
	
    /**
     * adds a <code>Link</code> to the <code>LinkVector</code>
     * @param link the <code>Link</code>
     */
    public void addLink(Link link) {
        super.addElement(link);
    }
	
    /**
     * returns the specified <code>Link</code> from the <code>LinkVector</code>
     * @param i the position of the <code>Link</code>
     * @return the <code>Link</code>
     */
    public Link linkAt(int i) {
        return (Link) super.elementAt(i);
    }
	
}
