/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.netobjects;




/**
 * a <code>Link</code> represents a links-set from the database
 *
 * @author Harald Weinreich
 * @author Volkert Buchmann
 */

public class Node2Key extends TableRecord {
    public static final String COPYRIGHT = "(C) Harald Weinreich & Volkert Buchmann";

    protected static DBTableAdapter dbTable;
	
    protected NetNode node;
    protected Keyword keyword;

    // set sql meta-data
    static {
        dbTable = new DBTableAdapter("Node2KeyTable"); 
		
        /*
         dbTable.addField("nodeId",           dbTable.STRING,"0",dbTable.KEY);
         dbTable.addField("keywordId",        dbTable.STRING,"0",dbTable.KEY);
         */
    }

    public String getKeywordId() {
        return fieldValues.get("keywordId");
    }

    public String getNodeId() {
        return fieldValues.get("nodeId");
    }

    public Keyword getKeyword() {
        return keyword;
    }

    public NetNode getNode() {
        return node;
    }
	
    public Node2Key(NetNode node, Keyword keyword) {
        this.node = node;
        this.keyword = keyword;
        dbTable.init(this);
        fieldValues.put("nodeId", node.getNodeId());
        fieldValues.put("keywordId", keyword.getKeywordId());
        dbTable.dbInit(this);
    }
	
    public void store() {
        dbTable.updateDB(this);
    }	
	
    public Object getKey(int KeyNo) {
        return node.getNodeId() + "\n" + keyword.getKeywordId();
    }	
}
