/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.netobjects;


/**
 * @author Harald Weinreich
 * @author Volkert Buchmann
 */

public class Person extends TableRecord {
    public static final String COPYRIGHT = "(C) Harald Weinreich & Volkert Buchmann";

    protected static DBTableAdapter dbTable;

    // set sql meta-data
    static {
        dbTable = new DBTableAdapter("PersonTable");
        
        /*

         dbTable.addField("personId",    dbTable.STRING,"",  dbTable.KEY);
         dbTable.addField("firstName",   dbTable.STRING,"",  dbTable.FIELD);
         dbTable.addField("secondName",  dbTable.STRING,"",  dbTable.FIELD);
         dbTable.addField("lastName",    dbTable.STRING,"",  dbTable.FIELD);
         dbTable.addField("organization",dbTable.STRING,"",  dbTable.FIELD);
         dbTable.addField("street",      dbTable.STRING,"",  dbTable.FIELD);
         dbTable.addField("city",        dbTable.STRING,"",  dbTable.FIELD);
         dbTable.addField("state",       dbTable.STRING,"",  dbTable.FIELD);
         dbTable.addField("postalCode",  dbTable.STRING,"",  dbTable.FIELD);
         dbTable.addField("phone1",      dbTable.STRING,"",  dbTable.FIELD);
         dbTable.addField("phone2",      dbTable.STRING,"",  dbTable.FIELD);
         dbTable.addField("mobile",      dbTable.STRING,"",  dbTable.FIELD);
         dbTable.addField("faxNumber",   dbTable.STRING,"",  dbTable.FIELD);
         dbTable.addField("email",       dbTable.STRING,"",  dbTable.FIELD);
         dbTable.addField("homepage",    dbTable.STRING,"",  dbTable.FIELD);
         */
    }

    public String getPersonId() {
        return fieldValues.get("personId");
    }

    public String getFirstName() {
        return fieldValues.get("firstName");
    }
    
    public void setFirstName(String value) {
        fieldValues.put("firstName", value);

    }

    public String getSecondName() {
        return fieldValues.get("secondName");
    }

    public void setSecondName(String value) {
        fieldValues.put("secondName", value);

    }

    public String getLastName() {
        return fieldValues.get("lastName");
    }

    public void setLastName(String value) {
        fieldValues.put("lastName", value);

    }

    public String getOrganization() {
        return fieldValues.get("organization");
    }

    public void setOrganization(String value) {
        fieldValues.put("organization", value);

    }

    public String getStreet() {
        return fieldValues.get("street");
    }

    public void setStreet(String value) {
        fieldValues.put("street", value);

    }

    public String getCity() {
        return fieldValues.get("city");
    }

    public void setCity(String value) {
        fieldValues.put("city", value);

    }

    public String getState() {
        return fieldValues.get("state");
    }

    public void setState(String value) {
        fieldValues.put("state", value);

    }

    public String getPostalCode() {
        return fieldValues.get("postalCode");
    }

    public void setPostalCode(String value) {
        fieldValues.put("postalCode", value);

    }

    public String getPhone1() {
        return fieldValues.get("phone1");
    }

    public void setPhone1(String value) {
        fieldValues.put("phone1", value);

    }

    public String getPhone2() {
        return fieldValues.get("phone2");
    }

    public void setPhone2(String value) {
        fieldValues.put("phone2", value);

    }

    public String getMobile() {
        return fieldValues.get("mobile");
    }

    public void setMobile(String value) {
        fieldValues.put("mobile", value);

    }

    public String getFaxnumber() {
        return fieldValues.get("faxnumber");
    }

    public void setFaxnumber(String value) {
        fieldValues.put("faxnumber", value);

    }

    public String getEmail() {
        return fieldValues.get("email");
    }

    public void setEmail(String value) {
        fieldValues.put("email", value);

    }

    public String getHomepage() {
        return fieldValues.get("homepage");
    }

    public void setHomepage(String value) {
        fieldValues.put("homepage", value);

    }

    public Person() {
        dbTable.init(this);
        dbTable.dbCreate(this); // force create
    }

    public Person(String id) {
        dbTable.init(this);
        fieldValues.put("personId", id);
        dbTable.dbInit(this);        
    }

    public void store() {
        dbTable.updateDB(this);
    }

    public Object getKey(int KeyNo) {
        return getPersonId();
    }

}
