/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.netobjects;




/**
 * Used to access and cache Person objects
 *
 * @author Harald Weinreich
 * @author Volkert Buchmann
 */

public class PersonCache implements TableRecordCacheInterface {

    protected static CacheTable cache;

    public static Object lock = new Object();
   
    public static void init(int timeTillCleanUp, int gcType) {
        cache = new CacheTable("Persons ", 1, timeTillCleanUp, gcType);
        lock = new Object();
    }
   
    /**
     * Returns a person by it id key
     */
   
    public static Person getById(String id) {
        Person person = null;

        synchronized (lock) {
            person = (Person) cache.get(0, id);
            if (person == null) {  // person not found, return null.
                person = new Person(id);
                cache.put(person);
            }
        }
        return person;
    }
   
    public static void clean() {
        cache.clean();
    }  
   
}
